/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.extension;

import java.io.File;
import org.apache.avalon.excalibur.extension.Extension;

public final class OptionalPackage {
    private final File m_file;
    private final Extension[] m_available;
    private final Extension[] m_required;

    public static final File[] toFiles(OptionalPackage[] packages) {
        File[] results = new File[packages.length];
        int i = 0;
        while (i < packages.length) {
            results[i] = packages[i].getFile();
            ++i;
        }
        return results;
    }

    public File getFile() {
        return this.m_file;
    }

    public Extension[] getRequiredExtensions() {
        return this.m_required;
    }

    public Extension[] getAvailableExtensions() {
        return this.m_available;
    }

    public boolean isCompatible(Extension extension) {
        int i = 0;
        while (i < this.m_available.length) {
            if (this.m_available[i].isCompatibleWith(extension)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("OptionalPackage[");
        sb.append(this.m_file);
        sb.append(", Available[");
        int i = 0;
        while (i < this.m_available.length) {
            sb.append(this.m_available);
            sb.append(" ");
            ++i;
        }
        sb.append("], Required[");
        i = 0;
        while (i < this.m_required.length) {
            sb.append(this.m_required);
            sb.append(" ");
            ++i;
        }
        sb.append("] ]");
        return sb.toString();
    }

    public OptionalPackage(File file, Extension[] available, Extension[] required) {
        if (file == null) {
            throw new NullPointerException("file property is null");
        }
        if (available == null) {
            throw new NullPointerException("available property is null");
        }
        if (required == null) {
            throw new NullPointerException("required property is null");
        }
        this.m_file = file;
        this.m_available = available;
        this.m_required = required;
    }
}

