/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.zip;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.zip.ZipException;
import org.apache.avalon.excalibur.zip.ExtraFieldUtils;
import org.apache.avalon.excalibur.zip.ZipExtraField;
import org.apache.avalon.excalibur.zip.ZipShort;

public class ZipEntry
extends java.util.zip.ZipEntry {
    private static Method setCompressedSizeMethod = null;
    private static Object lockReflection = new Object();
    private static boolean triedToGetMethod = false;
    private int internalAttributes = 0;
    private long externalAttributes = 0L;
    private ArrayList extraFields = new ArrayList();
    private Long compressedSize = null;
    static /* synthetic */ Class class$java$util$zip$ZipEntry;

    public ZipEntry(String name) {
        super(name);
    }

    public ZipEntry(java.util.zip.ZipEntry entry) throws ZipException {
        super(entry.getName());
        byte[] extra;
        long crc;
        long cSize;
        this.setComment(entry.getComment());
        this.setMethod(entry.getMethod());
        this.setTime(entry.getTime());
        long size = entry.getSize();
        if (size > 0L) {
            this.setSize(size);
        }
        if ((cSize = entry.getCompressedSize()) > 0L) {
            this.setComprSize(cSize);
        }
        if ((crc = entry.getCrc()) > 0L) {
            this.setCrc(crc);
        }
        if ((extra = entry.getExtra()) != null) {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        } else {
            this.setExtra();
        }
    }

    public ZipEntry(ZipEntry entry) throws ZipException {
        this((java.util.zip.ZipEntry)entry);
        this.setInternalAttributes(entry.getInternalAttributes());
        this.setExternalAttributes(entry.getExternalAttributes());
        this.setExtraFields(entry.getExtraFields());
    }

    private static void checkSCS() {
        if (!triedToGetMethod) {
            Object object = lockReflection;
            synchronized (object) {
                triedToGetMethod = true;
                try {
                    setCompressedSizeMethod = (class$java$util$zip$ZipEntry == null ? (class$java$util$zip$ZipEntry = ZipEntry.class$("java.util.zip.ZipEntry")) : class$java$util$zip$ZipEntry).getMethod("setCompressedSize", Long.TYPE);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean haveSetCompressedSize() {
        ZipEntry.checkSCS();
        return setCompressedSizeMethod != null;
    }

    private static void performSetCompressedSize(ZipEntry ze, long size) {
        Object[] s = new Long[]{new Long(size)};
        try {
            setCompressedSizeMethod.invoke((Object)ze, s);
        }
        catch (InvocationTargetException ite) {
            Throwable nested = ite.getTargetException();
            throw new RuntimeException("Exception setting the compressed size of " + ze + ": " + nested.getMessage());
        }
        catch (Throwable other) {
            throw new RuntimeException("Exception setting the compressed size of " + ze + ": " + other.getMessage());
        }
    }

    public void setComprSize(long size) {
        if (ZipEntry.haveSetCompressedSize()) {
            ZipEntry.performSetCompressedSize(this, size);
        } else {
            this.compressedSize = new Long(size);
        }
    }

    public void setExternalAttributes(long value) {
        this.externalAttributes = value;
    }

    public void setExtra(byte[] extra) throws RuntimeException {
        try {
            this.setExtraFields(ExtraFieldUtils.parse(extra));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void setExtraFields(ZipExtraField[] fields) {
        this.extraFields.clear();
        int i = 0;
        while (i < fields.length) {
            this.extraFields.add(fields[i]);
            ++i;
        }
        this.setExtra();
    }

    public void setInternalAttributes(int value) {
        this.internalAttributes = value;
    }

    public byte[] getCentralDirectoryExtra() {
        return ExtraFieldUtils.mergeCentralDirectoryData(this.getExtraFields());
    }

    public long getCompressedSize() {
        if (this.compressedSize != null) {
            return this.compressedSize;
        }
        return super.getCompressedSize();
    }

    public long getExternalAttributes() {
        return this.externalAttributes;
    }

    public ZipExtraField[] getExtraFields() {
        ZipExtraField[] result = new ZipExtraField[this.extraFields.size()];
        return this.extraFields.toArray(result);
    }

    public int getInternalAttributes() {
        return this.internalAttributes;
    }

    public byte[] getLocalFileDataExtra() {
        byte[] extra = this.getExtra();
        return extra != null ? extra : new byte[]{};
    }

    public void addExtraField(ZipExtraField ze) {
        ZipShort type = ze.getHeaderId();
        boolean done = false;
        int i = 0;
        while (!done && i < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.get(i)).getHeaderId().equals(type)) {
                this.extraFields.set(i, ze);
                done = true;
            }
            ++i;
        }
        if (!done) {
            this.extraFields.add(ze);
        }
        this.setExtra();
    }

    public Object clone() {
        ZipEntry e = null;
        try {
            e = new ZipEntry((java.util.zip.ZipEntry)super.clone());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        e.setInternalAttributes(this.getInternalAttributes());
        e.setExternalAttributes(this.getExternalAttributes());
        e.setExtraFields(this.getExtraFields());
        return e;
    }

    public void removeExtraField(ZipShort type) {
        boolean done = false;
        int i = 0;
        while (!done && i < this.extraFields.size()) {
            if (((ZipExtraField)this.extraFields.get(i)).getHeaderId().equals(type)) {
                this.extraFields.remove(i);
                done = true;
            }
            ++i;
        }
        if (!done) {
            throw new NoSuchElementException();
        }
        this.setExtra();
    }

    protected void setExtra() {
        super.setExtra(ExtraFieldUtils.mergeLocalFileDataData(this.getExtraFields()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

