/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.avalon.excalibur.cache.CacheEvent;
import org.apache.avalon.excalibur.cache.CacheListener;
import org.apache.avalon.excalibur.cache.CacheValidator;

public class TimeoutValidator
implements CacheValidator,
CacheListener {
    private long m_timeout;
    private Map m_timestamps;

    public boolean validate(Object key, Object value) {
        long timestamp = (Long)this.m_timestamps.get(key);
        return System.currentTimeMillis() - timestamp <= this.m_timeout;
    }

    public void added(CacheEvent event) {
        this.m_timestamps.put(event.getKey(), new Long(System.currentTimeMillis()));
    }

    public void removed(CacheEvent event) {
        this.m_timestamps.remove(event.getKey());
    }

    public TimeoutValidator(long timeout) {
        if (0L >= timeout) {
            throw new IllegalArgumentException("Timeout must be greatter than 0");
        }
        this.m_timeout = timeout;
        this.m_timestamps = new HashMap();
    }
}

