/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import org.apache.avalon.excalibur.pool.DefaultPool;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.PoolController;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.Resizable;

public class SoftResourceLimitingPool
extends DefaultPool
implements Resizable {
    public void initialize() throws Exception {
        this.grow(this.m_min);
        this.m_initialized = true;
    }

    public void grow(int amount) {
        try {
            try {
                this.m_mutex.lock();
                int i = 0;
                while (i < amount) {
                    block7: {
                        try {
                            this.m_ready.add(this.newPoolable());
                        }
                        catch (Exception e) {
                            if (this.getLogger() == null) break block7;
                            this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": could not be instantiated.", (Throwable)e);
                        }
                    }
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
                Object var3_6 = null;
                this.m_mutex.unlock();
            }
            Object var3_5 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public void shrink(int amount) {
        try {
            try {
                this.m_mutex.lock();
                int i = 0;
                while (i < amount) {
                    block8: {
                        if (this.m_ready.size() > this.m_min) {
                            try {
                                this.removePoolable((Poolable)this.m_ready.remove(0));
                            }
                            catch (Exception e) {
                                if (this.getLogger() == null) break block8;
                                this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": improperly decommissioned.", (Throwable)e);
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (InterruptedException ie) {
                this.getLogger().warn("Interrupted while waiting on lock", (Throwable)ie);
                Object var3_6 = null;
                this.m_mutex.unlock();
            }
            Object var3_5 = null;
            this.m_mutex.unlock();
        }
        catch (Throwable throwable) {
            Object var3_7 = null;
            this.m_mutex.unlock();
            throw throwable;
        }
    }

    public SoftResourceLimitingPool(ObjectFactory factory) throws Exception {
        this(factory, 4);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min) throws Exception {
        this(factory, null, min, min * 2);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, int min, int max) throws Exception {
        this(factory, null, min, max);
    }

    public SoftResourceLimitingPool(ObjectFactory factory, PoolController controller, int min, int max) throws Exception {
        super(factory, controller, min, max);
    }
}

