/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultComponentFactory;
import org.apache.avalon.excalibur.component.DefaultComponentPool;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.context.Context;
import org.apache.log.Logger;

public class PoolableComponentHandler
extends ComponentHandler {
    private final DefaultComponentFactory m_factory;
    private final DefaultComponentPool m_pool;
    private boolean m_initialized = false;
    private boolean m_disposed = false;

    public void setLogger(Logger logger) {
        this.m_factory.setLogger(logger);
        this.m_pool.setLogger(logger);
        super.setLogger(logger);
    }

    public void initialize() {
        if (this.m_initialized) {
            return;
        }
        try {
            this.m_pool.initialize();
        }
        catch (Exception e) {
            this.getLogger().error("Cannot use component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
        }
        this.getLogger().debug("ComponentHandler initialized for: " + this.m_factory.getCreatedClass().getName());
        this.m_initialized = true;
    }

    public Component get() throws Exception {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot get a component from an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot get a component from a disposed holder");
        }
        return (Component)this.m_pool.get();
    }

    public void put(Component component) {
        if (!this.m_initialized) {
            throw new IllegalStateException("You cannot put a component in an uninitialized holder.");
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot put a component in a disposed holder");
        }
        this.m_pool.put((Poolable)component);
    }

    public void dispose() {
        this.m_disposed = true;
        try {
            this.m_pool.dispose();
            if (this.m_factory instanceof Disposable) {
                ((Disposable)this.m_factory).dispose();
            }
        }
        catch (Exception e) {
            this.getLogger().warn("Error decommissioning component: " + this.m_factory.getCreatedClass().getName(), (Throwable)e);
        }
    }

    protected PoolableComponentHandler(Class componentClass, Configuration config, ComponentManager manager, Context context, RoleManager roles) throws Exception {
        this.m_factory = new DefaultComponentFactory(componentClass, config, manager, context, roles);
        this.m_pool = new DefaultComponentPool(this.m_factory);
    }
}

