/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.security;

import java.io.File;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import org.apache.avalon.Component;
import org.apache.avalon.Loggable;
import org.apache.avalon.util.io.FileUtil;
import org.apache.log.Logger;

public abstract class AbstractPolicy
extends Policy
implements Component,
Loggable {
    protected static final boolean DEBUG = true;
    protected final ArrayList m_entries = new ArrayList();
    protected Logger m_logger;

    public void setLogger(Logger logger) {
        this.m_logger = logger;
    }

    public PermissionCollection getPermissions(CodeSource codeSource) {
        codeSource = this.normalize(codeSource);
        this.getLogger().debug("getPermissions(" + codeSource.getLocation() + ");");
        Permissions permissions = new Permissions();
        int n = this.m_entries.size();
        int n2 = 0;
        while (n2 < n) {
            PolicyEntry policyEntry = (PolicyEntry)this.m_entries.get(n2);
            if (policyEntry.m_codeSource.implies(codeSource)) {
                this.getLogger().debug(policyEntry.m_codeSource.getLocation() + " implies " + codeSource.getLocation());
                this.copyPermissions(permissions, policyEntry.m_permissions);
            }
            ++n2;
        }
        this.getLogger().debug(codeSource.getLocation() + " permissions = " + permissions);
        return permissions;
    }

    public void refresh() {
    }

    protected CodeSource normalize(CodeSource codeSource) {
        Serializable serializable;
        URL uRL = codeSource.getLocation();
        if (null == uRL) {
            return codeSource;
        }
        String string = null;
        if (!uRL.getProtocol().equalsIgnoreCase("file")) {
            string = uRL.getFile();
            string = FileUtil.normalize(string);
        } else {
            serializable = new File(uRL.getFile());
            string = serializable.getAbsoluteFile().toString().replace(File.separatorChar, '/');
            string = FileUtil.normalize(string);
        }
        serializable = null;
        try {
            serializable = new URL(uRL.getProtocol(), uRL.getHost(), uRL.getPort(), string);
        }
        catch (MalformedURLException malformedURLException) {
            this.getLogger().warn("Error building codeBase", malformedURLException);
        }
        return new CodeSource((URL)serializable, codeSource.getCertificates());
    }

    protected void copyPermissions(Permissions permissions, Permissions permissions2) {
        Enumeration<Permission> enumeration = permissions2.elements();
        while (enumeration.hasMoreElements()) {
            permissions.add(enumeration.nextElement());
        }
    }

    protected Permissions createPermissionSetFor(String string, Certificate[] certificateArray) throws MalformedURLException {
        PolicyEntry policyEntry = new PolicyEntry();
        policyEntry.m_codeSource = new CodeSource(new URL(string), certificateArray);
        policyEntry.m_codeSource = this.normalize(policyEntry.m_codeSource);
        this.getLogger().debug("createPermissionSetFor(" + policyEntry.m_codeSource.getLocation() + ");");
        policyEntry.m_permissions = new Permissions();
        this.m_entries.add(policyEntry);
        return policyEntry.m_permissions;
    }

    protected final Logger getLogger() {
        return this.m_logger;
    }

    protected static final class PolicyEntry {
        CodeSource m_codeSource;
        Permissions m_permissions;

        protected PolicyEntry() {
        }
    }
}

