/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;

final class JavaDocReader
extends FilterReader {
    private boolean badChar = true;
    private boolean endOfLine = true;
    private boolean lastStar = true;
    private int c;
    private int lastC = -1;
    private boolean atEnd = false;
    private int _lineOffset = 0;

    public JavaDocReader(Reader in) {
        super(in);
        try {
            in.read();
            in.read();
            in.read();
        }
        catch (IOException e) {
            throw new RuntimeException("We weren't given javadoc!!");
        }
    }

    public int getLineOffset() {
        return this._lineOffset;
    }

    public int read() throws IOException {
        if (this.atEnd) {
            return -1;
        }
        if (this.endOfLine) {
            this.endOfLine = false;
            this.badChar = true;
        }
        do {
            this.c = this.in.read();
            if (this.lastStar && this.c == 47) {
                this.atEnd = true;
                return -1;
            }
            boolean bl = this.lastStar = this.c == 42;
            if (this.c == 13 || this.c == 10 || this.c == 12) {
                this.badChar = false;
                this.endOfLine = true;
                if (this.lastC != 13 || this.c != 10) {
                    ++this._lineOffset;
                }
            } else if (!this.badChar || this.c != 9 && this.c != 32 && this.c != 42) {
                this.badChar = false;
            }
            this.lastC = this.c;
        } while (this.badChar && this.c != -1);
        return this.c;
    }

    public int read(char[] b, int off, int len) throws IOException {
        if (this.atEnd) {
            return -1;
        }
        int i = off;
        while (i < len) {
            int c = this.read();
            if (c == -1) {
                this.atEnd = true;
                return i - off;
            }
            b[i] = (char)c;
            ++i;
        }
        return len;
    }

    public long skip(long n) throws IOException {
        int i = 1;
        while ((long)i <= n) {
            int c = this.read();
            if (c == -1) {
                return i - 1;
            }
            ++i;
        }
        return n;
    }

    public int available() throws IOException {
        return 0;
    }
}

