/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.util.Random;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;

public class Cab
extends MatchingTask {
    private File cabFile;
    private File baseDir;
    private Vector filesets = new Vector();
    private boolean doCompress = true;
    private boolean doVerbose = false;
    private String cmdOptions;
    protected String archiveType = "cab";
    private static String myos = System.getProperty("os.name");
    private static boolean isWindows = myos.toLowerCase().indexOf("windows") >= 0;
    private static int counter = new Random().nextInt() % 100000;

    public void addFileset(FileSet set) {
        this.filesets.addElement(set);
    }

    protected void appendFiles(Vector files, DirectoryScanner ds) {
        String[] dsfiles = ds.getIncludedFiles();
        int i = 0;
        while (i < dsfiles.length) {
            files.addElement(dsfiles[i]);
            ++i;
        }
    }

    protected void checkConfiguration() throws BuildException {
        if (this.baseDir == null) {
            throw new BuildException("basedir attribute must be set!");
        }
        if (!this.baseDir.exists()) {
            throw new BuildException("basedir does not exist!");
        }
        if (this.cabFile == null) {
            throw new BuildException("cabfile attribute must be set!");
        }
    }

    protected Commandline createCommand(File listFile) {
        Commandline command = new Commandline();
        command.setExecutable("cabarc");
        command.createArgument().setValue("-r");
        command.createArgument().setValue("-p");
        if (!this.doCompress) {
            command.createArgument().setValue("-m");
            command.createArgument().setValue("none");
        }
        if (this.cmdOptions != null) {
            command.createArgument().setValue(this.cmdOptions);
        }
        command.createArgument().setValue("n");
        command.createArgument().setFile(this.cabFile);
        command.createArgument().setValue("@" + listFile.getAbsolutePath());
        return command;
    }

    protected ExecTask createExec() throws BuildException {
        ExecTask exec = (ExecTask)this.project.createTask("exec");
        exec.setOwningTarget(this.getOwningTarget());
        exec.setTaskName(this.getTaskName());
        exec.setDescription(this.getDescription());
        return exec;
    }

    protected File createListFile(Vector files) throws IOException {
        File listFile = this.createTempFile("ant", null);
        PrintWriter writer = new PrintWriter(new FileOutputStream(listFile));
        int i = 0;
        while (i < files.size()) {
            writer.println(files.elementAt(i).toString());
            ++i;
        }
        writer.close();
        return listFile;
    }

    protected File createTempFile(String prefix, String suffix) {
        if (suffix == null) {
            suffix = ".tmp";
        }
        String name = String.valueOf(prefix) + new DecimalFormat("#####").format(new Integer(counter++)) + suffix;
        String tmpdir = System.getProperty("java.io.tmpdir");
        if (tmpdir == null) {
            return new File(name);
        }
        return new File(tmpdir, name);
    }

    public void execute() throws BuildException {
        if (!isWindows) {
            this.log("cannot run on non-Windows platforms: " + myos, 3);
            return;
        }
        this.checkConfiguration();
        Vector files = this.getFileList();
        if (this.isUpToDate(files)) {
            return;
        }
        this.log("Building " + this.archiveType + ": " + this.cabFile.getAbsolutePath());
        try {
            File listFile = this.createListFile(files);
            ExecTask exec = this.createExec();
            File outFile = null;
            exec.setFailonerror(true);
            exec.setDir(this.baseDir);
            if (!this.doVerbose) {
                outFile = this.createTempFile("ant", null);
                exec.setOutput(outFile);
            }
            exec.setCommand(this.createCommand(listFile));
            exec.execute();
            if (outFile != null) {
                outFile.delete();
            }
            listFile.delete();
        }
        catch (IOException ioe) {
            String msg = "Problem creating " + this.cabFile + " " + ioe.getMessage();
            throw new BuildException(msg);
        }
    }

    protected Vector getFileList() throws BuildException {
        Vector files = new Vector();
        if (this.filesets.size() == 0) {
            this.appendFiles(files, super.getDirectoryScanner(this.baseDir));
        } else {
            int i = 0;
            while (i < this.filesets.size()) {
                FileSet fs = (FileSet)this.filesets.elementAt(i);
                if (fs != null) {
                    this.appendFiles(files, fs.getDirectoryScanner(this.project));
                }
                ++i;
            }
        }
        return files;
    }

    protected boolean isUpToDate(Vector files) {
        boolean upToDate = true;
        int i = 0;
        while (i < files.size() && upToDate) {
            String file = files.elementAt(i).toString();
            if (new File(this.baseDir, file).lastModified() > this.cabFile.lastModified()) {
                upToDate = false;
            }
            ++i;
        }
        return upToDate;
    }

    public void setBasedir(File baseDir) {
        this.baseDir = baseDir;
    }

    public void setCabfile(File cabFile) {
        this.cabFile = cabFile;
    }

    public void setCompress(boolean compress) {
        this.doCompress = compress;
    }

    public void setOptions(String options) {
        this.cmdOptions = options;
    }

    public void setVerbose(boolean verbose) {
        this.doVerbose = verbose;
    }
}

