/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class GUnzip
extends Task {
    private File source;
    private File dest;

    public void execute() throws BuildException {
        if (this.source == null) {
            throw new BuildException("No source for gunzip specified", this.location);
        }
        if (!this.source.exists()) {
            throw new BuildException("source doesn't exist", this.location);
        }
        if (this.source.isDirectory()) {
            throw new BuildException("Cannot expand a directory", this.location);
        }
        if (this.dest == null) {
            this.dest = new File(this.source.getParent());
        }
        if (this.dest.isDirectory()) {
            String sourceName = this.source.getName();
            int len = sourceName.length();
            this.dest = len > 3 && ".gz".equalsIgnoreCase(sourceName.substring(len - 3)) ? new File(this.dest, sourceName.substring(0, len - 3)) : new File(this.dest, sourceName);
        }
        if (this.source.lastModified() > this.dest.lastModified()) {
            GZIPInputStream zIn;
            block20: {
                this.log("Expanding " + this.source.getAbsolutePath() + " to " + this.dest.getAbsolutePath());
                FileOutputStream out = null;
                zIn = null;
                try {
                    try {
                        out = new FileOutputStream(this.dest);
                        zIn = new GZIPInputStream(new FileInputStream(this.source));
                        byte[] buffer = new byte[8192];
                        int count = 0;
                        do {
                            out.write(buffer, 0, count);
                        } while ((count = zIn.read(buffer, 0, buffer.length)) != -1);
                    }
                    catch (IOException ioe) {
                        String msg = "Problem expanding gzip " + ioe.getMessage();
                        throw new BuildException(msg, ioe, this.location);
                    }
                    Object var4_8 = null;
                    if (out == null) break block20;
                }
                catch (Throwable throwable) {
                    Object var4_9 = null;
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (zIn != null) {
                        try {
                            zIn.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
            if (zIn != null) {
                try {
                    zIn.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setDest(String dest) {
        this.dest = this.project.resolveFile(dest);
    }

    public void setSrc(String src) {
        this.source = this.project.resolveFile(src);
    }
}

