/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.Type;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.log4j.Category;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.util.Log;

public class TypeTagsHandler
extends XDocletTagSupport {
    public static final int TYPE_CONCRETE_TYPE = 0;
    public static final int TYPE_SUPERCLASS = 1;
    public static final int TYPE_HIERARCHY = 2;
    static /* synthetic */ Class class$xdoclet$tags$TypeTagsHandler;

    public static boolean isPrimitiveType(String name) {
        int index = name.indexOf(91);
        int end_index = name.lastIndexOf(93);
        if (index != -1 && end_index != -1) {
            String before_braket = name.substring(0, index);
            String after_braket = end_index + 1 < name.length() ? name.substring(end_index + 1) : "";
            name = before_braket.trim() + after_braket.trim();
        }
        return name.equals("int") || name.equals("long") || name.equals("float") || name.equals("double") || name.equals("boolean") || name.equals("byte") || name.equals("short") || name.equals("char");
    }

    public static boolean isOfType(Type cur_type, String type, int extent) {
        if (cur_type instanceof ClassDoc) {
            ClassDoc cur_class = (ClassDoc)cur_type;
            do {
                if (TypeTagsHandler.isInTypeList(type, cur_class.qualifiedName())) {
                    return true;
                }
                if (extent == 0) continue;
                if (cur_class.superclass() != null && TypeTagsHandler.isInTypeList(type, cur_class.superclass().qualifiedName())) {
                    return true;
                }
                ClassDoc[] interfaces = cur_class.interfaces();
                int j = 0;
                while (j < interfaces.length) {
                    if (TypeTagsHandler.isInterfaceDerivedFrom(interfaces[j], type)) {
                        return true;
                    }
                    ++j;
                }
            } while (extent == 2 && (cur_class = cur_class.superclass()) != null);
        } else {
            return TypeTagsHandler.isInTypeList(type, cur_type.toString());
        }
        return false;
    }

    public static int extractExtentType(String extent_str) {
        if (extent_str == null) {
            return 2;
        }
        if (extent_str.equalsIgnoreCase("concrete-type")) {
            return 0;
        }
        if (extent_str.equalsIgnoreCase("superclass")) {
            return 1;
        }
        if (extent_str.equalsIgnoreCase("hierarchy")) {
            return 2;
        }
        return 2;
    }

    private static boolean isInTypeList(String derived_from, String class_name) {
        StringTokenizer st = new StringTokenizer(derived_from, ",");
        while (st.hasMoreTokens()) {
            if (!st.nextToken().equals(class_name)) continue;
            return true;
        }
        return false;
    }

    private static boolean isInterfaceDerivedFrom(ClassDoc cur_interface, String derived_from) {
        if (TypeTagsHandler.isInTypeList(derived_from, cur_interface.qualifiedName())) {
            return true;
        }
        ClassDoc[] interfaces = cur_interface.interfaces();
        int i = 0;
        while (i < interfaces.length) {
            if (TypeTagsHandler.isInterfaceDerivedFrom(interfaces[i], derived_from)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean isPrimitiveOrString(String value) throws XDocletException {
        return TypeTagsHandler.isPrimitiveType(value) || value.equals("java.lang.String") || value.equals("String");
    }

    public void ifIsPrimitive(String template, Properties attributes) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$TypeTagsHandler == null ? (class$xdoclet$tags$TypeTagsHandler = TypeTagsHandler.class$("xdoclet.tags.TypeTagsHandler")) : class$xdoclet$tags$TypeTagsHandler, "ifIsPrimitive");
        String value = attributes.getProperty("value");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("value=" + value));
        }
        if (TypeTagsHandler.isPrimitiveType(value)) {
            this.generate(template);
        }
    }

    public void ifIsPrimitiveOrString(String template, Properties attributes) throws XDocletException {
        this.ifIsPrimitiveOrString_Impl(attributes, template, true);
    }

    public void ifIsNotPrimitiveOrString(String template, Properties attributes) throws XDocletException {
        this.ifIsPrimitiveOrString_Impl(attributes, template, false);
    }

    public void ifIsNotPrimitive(String template, Properties attributes) throws XDocletException {
        String value = attributes.getProperty("value");
        if (!TypeTagsHandler.isPrimitiveType(value)) {
            this.generate(template);
        }
    }

    public void ifIsNotOfType(String template, Properties attributes) throws XDocletException {
        this.ifIsOfType_Impl(template, attributes, false);
    }

    public void ifIsOfType(String template, Properties attributes) throws XDocletException {
        this.ifIsOfType_Impl(template, attributes, true);
    }

    protected void ifIsOfType_Impl(String template, Properties attributes, boolean condition) throws XDocletException {
        String value = attributes.getProperty("value");
        String type_name = attributes.getProperty("type");
        int extent = TypeTagsHandler.extractExtentType(attributes.getProperty("extent"));
        ClassDoc cur_type = null;
        if (value == null || value.equalsIgnoreCase("class")) {
            cur_type = this.getCurrentClass();
        } else if (value.equalsIgnoreCase("return-type")) {
            cur_type = this.getCurrentMethod().returnType();
            if (cur_type.asClassDoc() != null) {
                cur_type = cur_type.asClassDoc();
            }
        } else {
            cur_type = XDocletTagSupport.getDocletContext().getRoot().classNamed(value);
        }
        if (cur_type == null && this.getCurrentMethod().returnType().typeName().equals(type_name) == condition) {
            this.generate(template);
        } else if (TypeTagsHandler.isOfType((Type)cur_type, type_name, extent) == condition) {
            this.generate(template);
        }
    }

    private void ifIsPrimitiveOrString_Impl(Properties attributes, String template, boolean condition) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$tags$TypeTagsHandler == null ? (class$xdoclet$tags$TypeTagsHandler = TypeTagsHandler.class$("xdoclet.tags.TypeTagsHandler")) : class$xdoclet$tags$TypeTagsHandler, "ifIsPrimitiveOrString_Impl");
        String value = attributes.getProperty("value");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("value=" + value));
        }
        if (TypeTagsHandler.isPrimitiveOrString(value) == condition) {
            this.generate(template);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

