/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.PackageDoc;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import xdoclet.XDocletException;
import xdoclet.XDocletTagSupport;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.template.TemplateException;
import xdoclet.util.Translator;

public class PackageTagsHandler
extends AbstractProgramElementTagsHandler {
    public static String getPackageNameFor(PackageDoc pak) {
        return pak.name();
    }

    public static String getPackageFor(String fullClassName) {
        StringTokenizer st = new StringTokenizer(fullClassName, ".");
        String pack = "";
        while (st.hasMoreTokens()) {
            String nt = st.nextToken();
            if (!st.hasMoreTokens()) continue;
            pack = pack.equals("") ? nt : pack + "." + nt;
        }
        return pack;
    }

    public static String packageNameAsPathFor(PackageDoc pak) {
        return PackageTagsHandler.getPackageNameFor(pak).replace('.', '/');
    }

    public static String packageNameAsPathFor(String qualified_name) {
        return qualified_name.replace('.', '/');
    }

    public String packageName() throws XDocletException {
        if (this.getCurrentPackage() != null) {
            return this.getCurrentPackage().name();
        }
        return this.getCurrentClass().containingPackage().name();
    }

    public void packageOf(String template) throws XDocletException {
        try {
            String fullClassName = this.getEngine().outputOf(template);
            this.getEngine().print(fullClassName.substring(0, fullClassName.lastIndexOf(".")));
        }
        catch (TemplateException ex) {
            throw new XDocletException(ex, Translator.getString("method_failed", new String[]{"packageOf"}));
        }
    }

    public void forAllPackages(String template, Properties attributes) throws XDocletException {
        ClassDoc[] classes = XDocletTagSupport.getDocletContext().getRoot().classes();
        TreeSet<PackageDoc> packages = new TreeSet<PackageDoc>();
        int i = 0;
        while (i < classes.length) {
            packages.add(classes[i].containingPackage());
            ++i;
        }
        PackageDoc cur_package = null;
        Iterator packageIterator = packages.iterator();
        while (packageIterator.hasNext()) {
            cur_package = (PackageDoc)packageIterator.next();
            this.setCurrentPackage(cur_package);
            this.generate(template);
        }
        this.setCurrentPackage(null);
    }

    public String packageNameAsPath() throws XDocletException {
        return PackageTagsHandler.packageNameAsPathFor(this.packageName());
    }
}

