/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.tags;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.Tag;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import xdoclet.XDocletException;
import xdoclet.tags.AbstractProgramElementTagsHandler;
import xdoclet.util.Translator;
import xdoclet.util.TypeConversionUtil;

public class FieldTagsHandler
extends AbstractProgramElementTagsHandler {
    public void forAllFields(String template, Properties attributes) throws XDocletException {
        boolean superclasses = TypeConversionUtil.stringToBoolean(attributes.getProperty("superclasses"), true);
        boolean sort = TypeConversionUtil.stringToBoolean(attributes.getProperty("sort"), true);
        ClassDoc cur_class = this.getCurrentClass();
        HashMap<FieldDoc, FieldDoc> already = new HashMap<FieldDoc, FieldDoc>();
        do {
            FieldDoc[] fields = cur_class.fields();
            if (sort) {
                List<FieldDoc> the_list = Arrays.asList(fields);
                Collections.sort(the_list, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        FieldDoc m1 = (FieldDoc)o1;
                        FieldDoc m2 = (FieldDoc)o2;
                        return m1.name().compareTo(m2.name());
                    }

                    public boolean equals(Object obj) {
                        return obj == this;
                    }
                });
                fields = the_list.toArray(fields);
            }
            int j = 0;
            while (j < fields.length) {
                if ((!superclasses || superclasses && fields[j].containingClass() == cur_class) && !already.containsKey(fields[j])) {
                    this.setCurrentField(fields[j]);
                    already.put(fields[j], fields[j]);
                    this.generate(template);
                }
                ++j;
            }
        } while (superclasses && (cur_class = cur_class.superclass()) != null);
    }

    public void forAllFieldTags(String template, Properties attributes) throws XDocletException {
        if (this.getCurrentField() == null) {
            throw new XDocletException(Translator.getString("only_call_field_not_null", new String[]{"forAllFieldTags"}));
        }
        Tag[] tags = this.getCurrentField().tags(attributes.getProperty("tagName"));
        int i = 0;
        while (i < tags.length) {
            this.setCurrentTag(tags[i]);
            String m = this.getTagValue(attributes, 2);
            if (AbstractProgramElementTagsHandler.matchPattern == null) {
                this.generate(template);
            } else if (AbstractProgramElementTagsHandler.matchPattern != null && (AbstractProgramElementTagsHandler.matchPattern.equals(m) || m.equals("*"))) {
                this.generate(template);
            }
            ++i;
        }
        this.setCurrentTag(null);
    }

    public String fieldTagValue(Properties attributes) throws XDocletException {
        attributes.setProperty("field", "true");
        return this.getTagValue(attributes, 2);
    }

    public void ifHasFieldTag(String template, Properties attributes) throws XDocletException {
        if (this.ifHasTag_Impl(template, attributes, 2)) {
            this.generate(template);
        } else {
            String error = attributes.getProperty("error");
            if (error != null) {
                this.getEngine().print(error);
            }
        }
    }
}

