/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.EnumeratedAttribute;

public class FixCRLF
extends MatchingTask {
    private int addcr;
    private int addtab;
    private int ctrlz;
    private int tablength = 8;
    private File srcDir;
    private File destDir = null;

    public FixCRLF() {
        if (System.getProperty("path.separator").equals(":")) {
            this.addcr = -1;
            this.ctrlz = -1;
        } else {
            this.addcr = 1;
            this.ctrlz = 0;
        }
    }

    public void setSrcdir(File file) {
        this.srcDir = file;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public void setCr(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.addcr = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTab(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.addtab = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void setTablength(int n) throws BuildException {
        if (n < 2 || (n & n - 1) != 0) {
            throw new BuildException("tablength must be a positive power of 2", this.location);
        }
        this.tablength = n;
    }

    public void setEof(AddAsisRemove addAsisRemove) {
        String string = addAsisRemove.getValue();
        this.ctrlz = string.equals("remove") ? -1 : (string.equals("asis") ? 0 : 1);
    }

    public void execute() throws BuildException {
        if (this.srcDir == null) {
            throw new BuildException("srcdir attribute must be set!");
        }
        if (!this.srcDir.exists()) {
            throw new BuildException("srcdir does not exist!");
        }
        if (!this.srcDir.isDirectory()) {
            throw new BuildException("srcdir is not a directory!");
        }
        if (this.destDir != null) {
            if (!this.destDir.exists()) {
                throw new BuildException("destdir does not exist!");
            }
            if (!this.destDir.isDirectory()) {
                throw new BuildException("destdir is not a directory!");
            }
        }
        this.log("options: cr=" + (this.addcr == 1 ? "add" : (this.addcr == 0 ? "asis" : "remove")) + " tab=" + (this.addtab == 1 ? "add" : (this.addtab == 0 ? "asis" : "remove")) + " eof=" + (this.ctrlz == 1 ? "add" : (this.ctrlz == 0 ? "asis" : "remove")) + " tablength=" + this.tablength, 3);
        DirectoryScanner directoryScanner = super.getDirectoryScanner(this.srcDir);
        String[] stringArray = directoryScanner.getIncludedFiles();
        int n = 0;
        while (n < stringArray.length) {
            int n2;
            int n3;
            boolean bl;
            File file = new File(this.srcDir, stringArray[n]);
            int n4 = (int)file.length();
            byte[] byArray = new byte[n4];
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                fileInputStream.read(byArray);
                fileInputStream.close();
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            while (n8 < n4) {
                bl = byArray[n8];
                if (bl) {
                    ++n5;
                }
                if (bl) {
                    ++n6;
                }
                if (bl) {
                    ++n7;
                }
                ++n8;
            }
            bl = n4 > 0 && byArray[n4 - 1] == 26;
            this.log(file + ": size=" + n4 + " cr=" + n5 + " lf=" + n6 + " tab=" + n7 + " eof=" + bl, 3);
            int n9 = n4;
            if (this.addcr != 0) {
                n9 -= n5;
            }
            if (this.addcr == 1) {
                n9 += n6;
            }
            if (this.addtab == -1) {
                n9 += n7 * (this.tablength - 1);
            }
            if (this.ctrlz == 1) {
                ++n9;
            }
            byte[] byArray2 = new byte[n9];
            int n10 = n3 = 0;
            int n11 = 0;
            int n12 = 0;
            while (n12 < n4) {
                switch (byArray[n12]) {
                    case 32: {
                        if (this.addtab == 0) {
                            byArray2[n3++] = 32;
                        }
                        ++n11;
                        break;
                    }
                    case 9: {
                        if (this.addtab == 0) {
                            byArray2[n3++] = 9;
                            ++n11;
                            break;
                        }
                        n11 = (n11 | this.tablength - 1) + 1;
                        break;
                    }
                    case 13: {
                        if (this.addcr != 0) break;
                        byArray2[n3++] = 13;
                        ++n11;
                        break;
                    }
                    case 10: {
                        if (this.addcr == 1) {
                            byArray2[n3++] = 13;
                        }
                        byArray2[n3++] = 10;
                        n10 = n3;
                        n11 = 0;
                        break;
                    }
                    default: {
                        if (this.addtab > 0 && n3 + 1 < n10 + n11) {
                            n2 = n3 - n10;
                            while ((n2 | this.tablength - 1) < n11) {
                                byArray2[n3++] = 9;
                                n2 = n3 - (n10 -= this.tablength - 1 - (n2 & this.tablength - 1));
                            }
                        }
                        while (n3 < n10 + n11) {
                            byArray2[n3++] = 32;
                        }
                        byArray2[n3++] = byArray[n12];
                        ++n11;
                    }
                }
                ++n12;
            }
            if (this.ctrlz == 1) {
                if (byArray2[n3 - 1] != 26) {
                    byArray2[n3++] = 26;
                }
            } else if (this.ctrlz == -1) {
                if (n3 > 2 && byArray2[n3 - 1] == 10 && byArray2[n3 - 2] == 26) {
                    --n3;
                }
                if (n3 > 1 && byArray2[n3 - 1] == 26) {
                    --n3;
                }
            }
            try {
                int n13;
                n2 = 0;
                byte[] byArray3 = byArray;
                File file2 = file;
                if (this.destDir != null) {
                    file2 = new File(this.destDir, stringArray[n]);
                    if (file2.isFile()) {
                        n13 = (int)file2.length();
                        if (n13 != n3) {
                            n2 = 1;
                        } else {
                            byArray3 = new byte[n13];
                            try {
                                FileInputStream fileInputStream = new FileInputStream(file2);
                                fileInputStream.read(byArray3);
                                fileInputStream.close();
                            }
                            catch (IOException iOException) {
                                throw new BuildException(iOException);
                            }
                        }
                    } else {
                        n2 = 1;
                    }
                }
                if (n2 == 0) {
                    if (byArray3.length != n3) {
                        n2 = 1;
                    } else {
                        n13 = 0;
                        while (n13 < n3) {
                            if (byArray3[n13] != byArray2[n13]) {
                                n2 = 1;
                                break;
                            }
                            ++n13;
                        }
                    }
                }
                if (n2 != 0) {
                    this.log(file2 + " is being written", 3);
                    FileOutputStream fileOutputStream = new FileOutputStream(file2);
                    fileOutputStream.write(byArray2, 0, n3);
                    fileOutputStream.close();
                } else {
                    this.log(file2 + " is not written, as the contents are identical", 3);
                }
            }
            catch (IOException iOException) {
                throw new BuildException(iOException);
            }
            ++n;
        }
    }

    public static class AddAsisRemove
    extends EnumeratedAttribute {
        public String[] getValues() {
            return new String[]{"add", "asis", "remove"};
        }
    }
}

