/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.collections;

import java.util.NoSuchElementException;
import org.apache.avalon.excalibur.collections.PriorityQueue;

public final class SynchronizedPriorityQueue
implements PriorityQueue {
    private final PriorityQueue m_priorityQueue;

    public SynchronizedPriorityQueue(PriorityQueue priorityQueue) {
        this.m_priorityQueue = priorityQueue;
    }

    public void clear() {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            this.m_priorityQueue.clear();
        }
    }

    public boolean isEmpty() {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            boolean bl = this.m_priorityQueue.isEmpty();
            return bl;
        }
    }

    public void insert(Object element) {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            this.m_priorityQueue.insert(element);
        }
    }

    public Object peek() throws NoSuchElementException {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            Object object = this.m_priorityQueue.peek();
            return object;
        }
    }

    public Object pop() throws NoSuchElementException {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            Object object = this.m_priorityQueue.pop();
            return object;
        }
    }

    public String toString() {
        PriorityQueue priorityQueue = this.m_priorityQueue;
        synchronized (priorityQueue) {
            String string = this.m_priorityQueue.toString();
            return string;
        }
    }
}

