/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import org.apache.avalon.excalibur.logger.LogTargetFactory;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.log.LogTarget;
import org.apache.log.output.AsyncLogTarget;

public final class AsyncLogTargetFactory
extends AbstractTargetFactory
implements LogTargetFactoryManageable {
    protected LogTargetFactoryManager m_logTargetFactoryManager;

    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        int thread_priority;
        int n;
        AsyncLogTarget asyncTarget;
        int queuesize = configuration.getAttributeAsInteger("queue-size", -1);
        Configuration config = configuration.getChildren()[0];
        LogTargetFactory factory = this.m_logTargetFactoryManager.getLogTargetFactory(config.getName());
        LogTarget target = factory.createTarget(config);
        if (queuesize == -1) {
            AsyncLogTarget asyncLogTarget = new AsyncLogTarget(target);
        } else {
            asyncTarget = new AsyncLogTarget(target, queuesize);
        }
        String priority = configuration.getAttribute("priority", null);
        if ("MIN".equalsIgnoreCase(priority)) {
            n = 1;
        } else if ("NORM".equalsIgnoreCase(priority)) {
            n = 5;
        } else if ("NORM".equalsIgnoreCase(priority)) {
            n = 5;
        } else {
            thread_priority = configuration.getAttributeAsInteger("priority", 1);
        }
        Thread thread = new Thread((Runnable)asyncTarget);
        thread.setPriority(thread_priority);
        thread.start();
        return asyncTarget;
    }

    public final void setLogTargetFactoryManager(LogTargetFactoryManager logTargetFactoryManager) {
        this.m_logTargetFactoryManager = logTargetFactoryManager;
    }
}

