/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import xjavadoc.AbstractClass;
import xjavadoc.Token;
import xjavadoc.XClass;
import xjavadoc.XDoc;
import xjavadoc.XPackage;
import xjavadoc.XProgramElement;

abstract class AbstractProgramElement
implements XProgramElement {
    static final List EMPTY_LIST = Collections.unmodifiableList(new LinkedList());
    private AbstractClass _containingClass;
    private int _modifiers = 0;
    private String _modifierString;
    private XDoc _doc;
    private Token _token;
    private Token _javadocToken;

    protected AbstractProgramElement(AbstractClass containingClass) {
        this._containingClass = containingClass;
    }

    public final boolean isFinal() {
        return (this._modifiers & 0x10) != 0;
    }

    public final boolean isAbstract() {
        return (this._modifiers & 0x400) != 0;
    }

    public final boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isProtected() && !this.isPublic();
    }

    public final boolean isPrivate() {
        return (this._modifiers & 2) != 0;
    }

    public final boolean isProtected() {
        return (this._modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this._modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this._modifiers & 8) != 0;
    }

    public final XDoc getDoc() {
        if (this._doc == null) {
            if (this._token == null) {
                this._doc = new XDoc(null, this);
            } else if (this._javadocToken != null) {
                this._doc = new XDoc(this._javadocToken, this);
            } else {
                Token preJavadocToken = Token.newToken(0);
                preJavadocToken.image = "\n\n";
                this._javadocToken = Token.newToken(10);
                this._javadocToken.image = "";
                Token postJavadocToken = Token.newToken(0);
                postJavadocToken.image = "\n";
                preJavadocToken.next = this._javadocToken;
                this._javadocToken.next = postJavadocToken;
                this._token.specialToken = preJavadocToken;
                this._doc = new XDoc(this._javadocToken, this);
            }
        }
        return this._doc;
    }

    public final String getModifiers() {
        if (this._modifierString == null) {
            this._modifierString = Modifier.toString(this._modifiers);
        }
        return this._modifierString;
    }

    public final int getModifierSpecifier() {
        return this._modifiers;
    }

    public final XClass getContainingClass() {
        return this.getContainingAbstractClass();
    }

    public final AbstractClass getContainingAbstractClass() {
        return this._containingClass;
    }

    public XPackage getContainingPackage() {
        if (this._containingClass != null) {
            return this.getContainingClass().getContainingPackage();
        }
        return null;
    }

    public final void setToken(Token token) {
        if (this._token == null && token != null) {
            this._token = token;
            this.setJavaDoc();
        }
    }

    public final void addModifier(int modifier) {
        this._modifiers |= modifier;
    }

    public int compareTo(Object o) {
        XProgramElement other = (XProgramElement)o;
        return this.getName().compareTo(other.getName());
    }

    public void updateDoc() {
        if (this._doc != null) {
            this._doc.updateToken();
        }
    }

    void reset() {
        this._doc = null;
        this._containingClass = null;
        this._token = null;
        this._javadocToken = null;
    }

    private final void setJavaDoc() {
        Token javadoc = null;
        Token tt = this._token.specialToken;
        if (tt != null) {
            while (tt.specialToken != null) {
                tt = tt.specialToken;
            }
            while (tt != null) {
                if (tt.kind == 10) {
                    javadoc = tt;
                } else if (tt.kind == 9 || tt.kind == 11) {
                    javadoc = null;
                }
                tt = tt.next;
            }
        }
        if (javadoc != null) {
            if (this._doc != null) {
                throw new IllegalStateException("Doc has already been set!!");
            }
            this._javadocToken = javadoc;
        }
    }
}

