/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log.output;

import java.util.LinkedList;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;

public class AsyncLogTarget
implements LogTarget,
Runnable {
    protected final LinkedList m_list;
    protected final int m_queueSize;
    protected final LogTarget m_logTarget;

    public void processEvent(LogEvent event) {
        LinkedList linkedList = this.m_list;
        synchronized (linkedList) {
            int size = this.m_list.size();
            while (this.m_queueSize <= size) {
                try {
                    this.m_list.wait();
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            this.m_list.addFirst(event);
            if (size == 0) {
                this.m_list.notify();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        boolean interupted = false;
        while (true) {
            LogEvent event = null;
            LinkedList linkedList = this.m_list;
            synchronized (linkedList) {
                while (event == null) {
                    int size = this.m_list.size();
                    if (size > 0) {
                        event = (LogEvent)this.m_list.removeLast();
                        if (size != this.m_queueSize) continue;
                        this.m_list.notify();
                        continue;
                    }
                    if (interupted) return;
                    if (Thread.interrupted()) {
                        return;
                    }
                    try {
                        this.m_list.wait();
                    }
                    catch (InterruptedException ie) {
                        interupted = true;
                    }
                }
            }
            this.m_logTarget.processEvent(event);
        }
    }

    public AsyncLogTarget(LogTarget logTarget) {
        this(logTarget, 15);
    }

    public AsyncLogTarget(LogTarget logTarget, int queueSize) {
        this.m_logTarget = logTarget;
        this.m_list = new LinkedList();
        this.m_queueSize = queueSize;
    }
}

