/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.thread.impl;

import org.apache.avalon.excalibur.lang.ThreadContext;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.SoftResourceLimitingPool;
import org.apache.avalon.excalibur.thread.ThreadControl;
import org.apache.avalon.excalibur.thread.ThreadPool;
import org.apache.avalon.excalibur.thread.impl.ExecutableRunnable;
import org.apache.avalon.excalibur.thread.impl.WorkerThread;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.logger.LogEnabled;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Logger;

public class DefaultThreadPool
extends ThreadGroup
implements ObjectFactory,
Loggable,
LogEnabled,
ThreadPool {
    private final SoftResourceLimitingPool m_pool;
    private int m_level;
    private org.apache.avalon.framework.logger.Logger m_logger;
    private ThreadContext m_context;
    private static /* synthetic */ Class class$Lorg$apache$avalon$excalibur$thread$impl$WorkerThread;

    public void setLogger(Logger logger) {
        this.enableLogging((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    public void enableLogging(org.apache.avalon.framework.logger.Logger logger) {
        this.m_logger = logger;
        this.m_pool.enableLogging(this.m_logger);
        try {
            this.m_pool.initialize();
        }
        catch (Exception e) {
            this.m_logger.fatalError("Could not initialize the pool", (Throwable)e);
        }
    }

    public Object newInstance() {
        String name = this.getName() + " Worker #" + this.m_level++;
        WorkerThread worker = new WorkerThread((ThreadGroup)this, name, this.m_pool, this.m_context);
        worker.setLogger(this.m_logger);
        worker.start();
        return worker;
    }

    public void decommission(Object object) {
        if (object instanceof WorkerThread) {
            ((WorkerThread)object).dispose();
        }
    }

    public Class getCreatedClass() {
        return class$Lorg$apache$avalon$excalibur$thread$impl$WorkerThread != null ? class$Lorg$apache$avalon$excalibur$thread$impl$WorkerThread : (class$Lorg$apache$avalon$excalibur$thread$impl$WorkerThread = DefaultThreadPool.class$("org.apache.avalon.excalibur.thread.impl.WorkerThread"));
    }

    public ThreadControl execute(Runnable work) {
        return this.execute(new ExecutableRunnable(work));
    }

    public ThreadControl execute(Executable work) {
        WorkerThread worker = this.getWorker();
        return worker.execute(work);
    }

    /*
     * WARNING - void declaration
     */
    protected WorkerThread getWorker() {
        try {
            void e;
            WorkerThread worker = (WorkerThread)this.m_pool.get();
            worker.setContextClassLoader(Thread.currentThread().getContextClassLoader());
            return e;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to access thread pool due to " + e);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public DefaultThreadPool(int capacity) throws Exception {
        this("Worker Pool", capacity);
    }

    public DefaultThreadPool(String name, int capacity) throws Exception {
        this(name, capacity, null);
    }

    public DefaultThreadPool(String name, int capacity, ThreadContext context) throws Exception {
        super(name);
        this.m_pool = new SoftResourceLimitingPool((ObjectFactory)this, capacity);
        this.m_context = context;
    }
}

