/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xalan.stree.Child;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.SubContextList;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.patterns.NodeTest;
import org.w3c.dom.Node;

public abstract class PredicatedNodeTest
extends NodeTest
implements SubContextList {
    protected LocPathIterator m_lpi;
    transient int m_predicateIndex = -1;
    private Expression[] m_predicates;
    protected transient int[] m_proximityPositions;
    static final boolean DEBUG_PREDICATECOUNTING = false;

    public PredicatedNodeTest() {
    }

    public PredicatedNodeTest(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public short acceptNode(Node node) {
        XPathContext xPathContext;
        block6: {
            short s;
            xPathContext = this.m_lpi.getXPathContext();
            try {
                try {
                    xPathContext.pushCurrentNode(node);
                    XObject xObject = this.execute(xPathContext, node);
                    if (xObject == NodeTest.SCORE_NONE) break block6;
                    if (this.getPredicateCount() > 0) {
                        this.countProximityPosition(0);
                        if (!this.executePredicates(node, xPathContext)) {
                            short s2 = 3;
                            Object var5_7 = null;
                            xPathContext.popCurrentNode();
                            return s2;
                        }
                    }
                    s = 1;
                }
                catch (TransformerException transformerException) {
                    throw new RuntimeException(transformerException.getMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_10 = null;
                xPathContext.popCurrentNode();
                throw throwable;
            }
            Object var5_8 = null;
            xPathContext.popCurrentNode();
            return s;
        }
        Object var5_9 = null;
        xPathContext.popCurrentNode();
        return 3;
    }

    public boolean canTraverseOutsideSubtree() {
        int n = this.getPredicateCount();
        int n2 = 0;
        while (n2 < n) {
            if (this.getPredicate(n2).canTraverseOutsideSubtree()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public Object clone() throws CloneNotSupportedException {
        PredicatedNodeTest predicatedNodeTest = (PredicatedNodeTest)super.clone();
        if (this.m_proximityPositions != null && this.m_proximityPositions == predicatedNodeTest.m_proximityPositions) {
            predicatedNodeTest.m_proximityPositions = new int[this.m_proximityPositions.length];
            System.arraycopy(this.m_proximityPositions, 0, predicatedNodeTest.m_proximityPositions, 0, this.m_proximityPositions.length);
        }
        if (predicatedNodeTest.m_lpi == this) {
            predicatedNodeTest.m_lpi = (LocPathIterator)predicatedNodeTest;
        }
        return predicatedNodeTest;
    }

    protected void countProximityPosition(int n) {
        if (n < this.m_proximityPositions.length) {
            int n2 = n;
            this.m_proximityPositions[n2] = this.m_proximityPositions[n2] + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean executePredicates(Node node, XPathContext xPathContext) throws TransformerException {
        PrefixResolver prefixResolver;
        block13: {
            boolean bl;
            block12: {
                this.m_predicateIndex = 0;
                int n = this.getPredicateCount();
                if (n == 0) {
                    return true;
                }
                prefixResolver = xPathContext.getNamespaceContext();
                try {
                    xPathContext.pushSubContextList(this);
                    xPathContext.setNamespaceContext(this.m_lpi.getPrefixResolver());
                    xPathContext.pushCurrentNode(node);
                    int n2 = 0;
                    while (n2 < n) {
                        XObject xObject;
                        int n3 = this.m_lpi.m_waitingBottom;
                        this.m_lpi.m_waitingBottom = this.m_lpi.getWaitingCount();
                        try {
                            xObject = this.m_predicates[n2].execute(xPathContext);
                        }
                        finally {
                            Object var12_10 = null;
                            this.m_lpi.m_waitingBottom = n3;
                        }
                        if (xObject.getType() == 2) {
                            int n4 = this.getProximityPosition(this.m_predicateIndex);
                            if (n4 != (int)xObject.num()) {
                                boolean bl2 = false;
                                Object var7_13 = null;
                                xPathContext.popCurrentNode();
                                xPathContext.setNamespaceContext(prefixResolver);
                                xPathContext.popSubContextList();
                                return bl2;
                            }
                        } else if (!xObject.bool()) {
                            bl = false;
                            break block12;
                        }
                        this.countProximityPosition(++this.m_predicateIndex);
                        ++n2;
                    }
                    break block13;
                }
                catch (Throwable throwable) {
                    Object var7_16 = null;
                    xPathContext.popCurrentNode();
                    xPathContext.setNamespaceContext(prefixResolver);
                    xPathContext.popSubContextList();
                    throw throwable;
                }
            }
            Object var7_14 = null;
            xPathContext.popCurrentNode();
            xPathContext.setNamespaceContext(prefixResolver);
            xPathContext.popSubContextList();
            return bl;
        }
        Object var7_15 = null;
        xPathContext.popCurrentNode();
        xPathContext.setNamespaceContext(prefixResolver);
        xPathContext.popSubContextList();
        this.m_predicateIndex = -1;
        return true;
    }

    public abstract int getLastPos(XPathContext var1);

    public LocPathIterator getLocPathIterator() {
        return this.m_lpi;
    }

    Expression getPredicate(int n) {
        return this.m_predicates[n];
    }

    public int getPredicateCount() {
        return this.m_predicates == null ? 0 : this.m_predicates.length;
    }

    public int getPredicateIndex() {
        return this.m_predicateIndex;
    }

    public int getProximityPosition() {
        return this.getProximityPosition(this.m_predicateIndex);
    }

    protected int getProximityPosition(int n) {
        return n >= 0 ? this.m_proximityPositions[n] : 0;
    }

    public int getProximityPosition(XPathContext xPathContext) {
        return this.getProximityPosition();
    }

    protected void initPredicateInfo(Compiler compiler, int n) throws TransformerException {
        int n2 = compiler.getFirstPredicateOpPos(n);
        this.m_predicates = compiler.getCompiledPredicates(n2);
    }

    public void initProximityPosition(int n) throws TransformerException {
        this.m_proximityPositions[n] = 0;
    }

    public boolean isReverseAxes() {
        return false;
    }

    protected String nodeToString(Node node) {
        try {
            return node != null ? String.valueOf(node.getNodeName()) + "{" + ((Child)node).getUid() + "}" : "null";
        }
        catch (ClassCastException classCastException) {
            return node != null ? node.getNodeName() : "null";
        }
    }

    public void resetProximityPositions() {
        int n = this.getPredicateCount();
        if (n > 0) {
            if (this.m_proximityPositions == null) {
                this.m_proximityPositions = new int[n];
            }
            int n2 = 0;
            while (n2 < n) {
                try {
                    this.initProximityPosition(n2);
                }
                catch (Exception exception) {
                    throw new WrappedRuntimeException(exception);
                }
                ++n2;
            }
        }
    }

    public void setLocPathIterator(LocPathIterator locPathIterator) {
        this.m_lpi = locPathIterator;
    }

    public void setPredicateCount(int n) {
        if (n > 0) {
            Expression[] expressionArray = new Expression[n];
            int n2 = 0;
            while (n2 < n) {
                expressionArray[n2] = this.m_predicates[n2];
                ++n2;
            }
            this.m_predicates = expressionArray;
        } else {
            this.m_predicates = null;
        }
    }
}

