/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.expr;

import java.util.List;
import org.jaxen.Navigator;
import org.jaxen.expr.DefaultEqualityExpr;
import org.jaxen.expr.Expr;
import org.jaxen.function.BooleanFunction;
import org.jaxen.function.NumberFunction;
import org.jaxen.function.StringFunction;

class DefaultEqualsExpr
extends DefaultEqualityExpr {
    public DefaultEqualsExpr(Expr lhs, Expr rhs) {
        super(lhs, rhs);
    }

    protected Object evaluateObjectObject(Object lhs, Object rhs) {
        if (lhs.equals(rhs)) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetBoolean(List theSet, Boolean theBool, Navigator nav) {
        int setSize = theSet.size();
        int i = 0;
        while (i < setSize) {
            if (theBool.equals(BooleanFunction.evaluate(theSet.get(i)))) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetNumber(List theSet, Number theNum, Navigator nav) {
        int setSize = theSet.size();
        int i = 0;
        while (i < setSize) {
            if (theNum.equals(NumberFunction.evaluate(theSet.get(i), nav))) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetSet(List lhsSet, List rhsSet, Navigator nav) {
        int lhsSize = lhsSet.size();
        int rhsSize = rhsSet.size();
        String lhsElem = null;
        String rhsElem = null;
        int i = 0;
        while (i < lhsSize) {
            lhsElem = StringFunction.evaluate(lhsSet.get(i), nav);
            int j = 0;
            while (j < rhsSize) {
                rhsElem = StringFunction.evaluate(rhsSet.get(j), nav);
                if (lhsElem.equals(rhsElem)) {
                    return Boolean.TRUE;
                }
                ++j;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    protected Object evaluateSetString(List theSet, String theStr, Navigator nav) {
        int setSize = theSet.size();
        int i = 0;
        while (i < setSize) {
            if (theStr.equals(StringFunction.evaluate(theSet.get(i), nav))) {
                return Boolean.TRUE;
            }
            ++i;
        }
        return Boolean.FALSE;
    }

    public String getOperator() {
        return "=";
    }

    public String toString() {
        return "[(DefaultEqualsExpr): " + this.getLHS() + ", " + this.getRHS() + "]";
    }
}

