/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.camelot;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.camelot.Info;
import org.apache.avalon.framework.camelot.Registry;
import org.apache.avalon.framework.camelot.RegistryException;

public class DefaultRegistry
implements Registry {
    protected final HashMap m_infos = new HashMap();
    protected final Class m_infoClass;

    public void register(String string, Info info) throws RegistryException {
        if (this.m_infos.get(string) != null) {
            throw new RegistryException("Name " + string + " already registered");
        }
        this.checkInfo(string, info);
        this.m_infos.put(string, info);
    }

    public void unregister(String string) throws RegistryException {
        if (this.m_infos.remove(string) == null) {
            throw new RegistryException("Name " + string + " not registered");
        }
    }

    public Info getInfo(String string, Class clazz) throws RegistryException {
        Info info = (Info)this.m_infos.get(string);
        if (info == null) {
            throw new RegistryException("Name " + string + " not registered");
        }
        if (!clazz.isInstance(info)) {
            throw new RegistryException("Info of type " + info.getClass().getName() + " not compatable with expected type " + clazz.getName());
        }
        return info;
    }

    public Iterator getInfoNames() {
        return this.m_infos.keySet().iterator();
    }

    protected void checkInfo(String string, Info info) throws RegistryException {
        if (!this.m_infoClass.isAssignableFrom(info.getClass())) {
            throw new RegistryException("Only Infos of type " + this.m_infoClass.getName() + " may be placed in registry.");
        }
    }

    public DefaultRegistry(Class clazz) {
        this.m_infoClass = clazz;
    }
}

