/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.camelot;

import java.net.URL;
import java.net.URLClassLoader;
import org.apache.avalon.framework.ExceptionUtil;
import org.apache.avalon.framework.camelot.FactoryException;
import org.apache.avalon.framework.camelot.Loader;

public class DefaultLoader
implements Loader {
    protected ClassLoader m_classLoader;

    public ClassLoader getClassLoader() {
        return this.m_classLoader;
    }

    public Object load(String string, Class clazz) throws FactoryException {
        Object object = this.load(string);
        if (!clazz.isInstance(object)) {
            throw new FactoryException("Created object of type " + object.getClass().getName() + " not compatable with type " + clazz.getName());
        }
        return object;
    }

    public Object load(String string) throws FactoryException {
        try {
            return this.m_classLoader.loadClass(string).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new FactoryException("Failed to locate class " + string, classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new FactoryException("Failed to instantiate class " + string, instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new FactoryException("Failed to instantiate class " + string + " as it does not have a publicly accesable " + "default constructor", illegalAccessException);
        }
        catch (Throwable throwable) {
            throw new FactoryException("Failed to get class " + string + " due to " + ExceptionUtil.printStackTrace((Throwable)throwable, (int)5, (boolean)true), throwable);
        }
    }

    public DefaultLoader(ClassLoader classLoader) {
        this.m_classLoader = classLoader;
    }

    public DefaultLoader(URL uRL, ClassLoader classLoader) {
        this.m_classLoader = new URLClassLoader(new URL[]{uRL}, classLoader);
    }

    public DefaultLoader(URL uRL) {
        this(uRL, Thread.currentThread().getContextClassLoader());
    }

    public DefaultLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.m_classLoader = new URLClassLoader(new URL[0], classLoader);
    }
}

