/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.camelot;

import java.util.HashMap;
import java.util.Iterator;
import org.apache.avalon.framework.camelot.Container;
import org.apache.avalon.framework.camelot.ContainerException;
import org.apache.avalon.framework.camelot.Entry;
import org.apache.avalon.framework.logger.AbstractLoggable;

public abstract class AbstractContainer
extends AbstractLoggable
implements Container {
    protected final HashMap m_entries = new HashMap();
    protected Class m_entryClass;

    public void add(String string, Entry entry) throws ContainerException {
        this.checkEntry(string, entry);
        this.preAdd(string, entry);
        this.m_entries.put(string, entry);
        this.postAdd(string, entry);
    }

    public void remove(String string) throws ContainerException {
        Entry entry = (Entry)this.m_entries.get(string);
        if (entry == null) {
            throw new ContainerException("Component named " + string + " not contained");
        }
        this.preRemove(string, entry);
        this.m_entries.remove(string);
        this.postRemove(string, entry);
    }

    public Entry getEntry(String string) throws ContainerException {
        Entry entry = (Entry)this.m_entries.get(string);
        if (entry == null) {
            throw new ContainerException("Name " + string + " not contained");
        }
        return entry;
    }

    public Iterator list() {
        return this.m_entries.keySet().iterator();
    }

    protected void preAdd(String string, Entry entry) throws ContainerException {
    }

    protected void postAdd(String string, Entry entry) {
    }

    protected void preRemove(String string, Entry entry) throws ContainerException {
    }

    protected void postRemove(String string, Entry entry) {
    }

    protected Iterator listEntries() {
        return this.m_entries.values().iterator();
    }

    protected void checkEntry(String string, Entry entry) throws ContainerException {
        if (this.m_entries.get(string) != null) {
            throw new ContainerException("Can not add component to container because entry already exists with name " + string);
        }
        if (!this.isValidName(string)) {
            throw new ContainerException("Can not add component to container because invalid name " + string);
        }
        if (!this.isValidEntry(entry)) {
            throw new ContainerException("Can not add component to container because invalid entry for " + string);
        }
        if (!this.m_entryClass.isAssignableFrom(entry.getClass())) {
            throw new ContainerException("Only Entries of type " + this.m_entryClass.getName() + " may be placed in container.");
        }
    }

    protected boolean isValidName(String string) throws ContainerException {
        return true;
    }

    protected boolean isValidEntry(Entry entry) throws ContainerException {
        return true;
    }
}

