/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.atlantis;

import java.util.HashMap;
import org.apache.avalon.framework.atlantis.ManagerException;
import org.apache.avalon.framework.atlantis.SystemManager;
import org.apache.avalon.framework.logger.AbstractLoggable;

public abstract class AbstractSystemManager
extends AbstractLoggable
implements SystemManager {
    private HashMap m_entrys = new HashMap();

    public synchronized void register(String string, Object object, Class[] classArray) throws ManagerException, IllegalArgumentException {
        this.checkRegister(string, object);
        if (classArray == null) {
            throw new IllegalArgumentException("Null interfaces parameter");
        }
        this.verifyInterfaces(object, classArray);
        ManagedEntry managedEntry = new ManagedEntry();
        managedEntry.m_object = object;
        managedEntry.m_interfaces = classArray;
        managedEntry.m_exportedObject = this.export(string, managedEntry.m_object, classArray);
        this.m_entrys.put(string, managedEntry);
    }

    public synchronized void register(String string, Object object) throws ManagerException, IllegalArgumentException {
        this.checkRegister(string, object);
        ManagedEntry managedEntry = new ManagedEntry();
        managedEntry.m_object = object;
        managedEntry.m_interfaces = null;
        managedEntry.m_exportedObject = this.export(string, managedEntry.m_object, null);
        this.m_entrys.put(string, managedEntry);
    }

    public synchronized void unregister(String string) throws ManagerException {
        ManagedEntry managedEntry = (ManagedEntry)this.m_entrys.remove(string);
        if (managedEntry == null) {
            throw new ManagerException("No such entry");
        }
        this.unexport(string, managedEntry.m_exportedObject);
    }

    protected abstract Object export(String var1, Object var2, Class[] var3) throws ManagerException;

    protected abstract void unexport(String var1, Object var2) throws ManagerException;

    protected abstract void verifyInterface(Class var1) throws ManagerException;

    private void verifyInterfaces(Object object, Class[] classArray) throws ManagerException {
        int n = 0;
        while (n < classArray.length) {
            Class clazz = classArray[n];
            if (!clazz.isInterface()) {
                throw new ManagerException("Can not export " + clazz.getName() + " for management as it is not an interface");
            }
            if (!clazz.isInstance(object)) {
                throw new ManagerException("Can not export " + clazz.getName() + " for management as object does not " + "implement interface");
            }
            this.verifyInterface(clazz);
            ++n;
        }
    }

    private void checkRegister(String string, Object object) throws ManagerException, IllegalArgumentException {
        if (object == null) {
            throw new IllegalArgumentException("Null object parameter");
        }
        if (string == null) {
            throw new IllegalArgumentException("Null name parameter");
        }
        if (this.m_entrys.get(string) != null) {
            throw new ManagerException("Entry already exisits");
        }
    }

    public abstract void initialize() throws Exception;

    public abstract void start() throws Exception;

    public abstract void stop() throws Exception;

    public abstract void dispose() throws Exception;

    protected static final class ManagedEntry {
        protected Object m_object;
        protected Class[] m_interfaces;
        protected Object m_exportedObject;

        ManagedEntry() {
        }
    }
}

