/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.source;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.source.Source;
import org.apache.avalon.excalibur.source.SourceFactory;
import org.apache.avalon.excalibur.source.SourceParameters;
import org.apache.avalon.excalibur.source.SourceResolver;
import org.apache.avalon.excalibur.source.URLSource;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class SourceResolverImpl
extends AbstractLoggable
implements Composable,
Configurable,
Contextualizable,
Disposable,
SourceResolver,
ThreadSafe {
    protected ComponentManager manager;
    protected ComponentSelector factorySelector;
    protected Context context;
    protected URL baseURL;

    public void configure(Configuration conf) throws ConfigurationException {
        try {
            this.baseURL = new File(System.getProperty("user.dir")).toURL();
        }
        catch (MalformedURLException mue) {
            throw new ConfigurationException("Malformed URL for user.dir");
        }
    }

    public void contextualize(Context context) throws ContextException {
        this.context = context;
    }

    public void compose(ComponentManager manager) throws ComponentException {
        this.manager = manager;
        this.factorySelector = (ComponentSelector)this.manager.lookup("org.apache.avalon.excalibur.source.SourceFactorySelector");
    }

    public void dispose() {
        if (this.manager != null) {
            this.manager.release((Component)this.factorySelector);
            this.factorySelector = null;
        }
    }

    public void setBaseURL(URL base) {
        if (SourceResolverImpl.super.getLogger().isDebugEnabled()) {
            SourceResolverImpl.super.getLogger().debug("Changing baseURL to: " + base);
        }
        this.baseURL = base;
    }

    public URL getBaseURL() {
        return this.baseURL;
    }

    public Source resolve(String location) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(this.baseURL, location, null);
    }

    public Source resolve(String location, SourceParameters parameters) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(this.baseURL, location, parameters);
    }

    public Source resolve(URL base, String location) throws MalformedURLException, IOException, ComponentException {
        return this.resolve(base, location, null);
    }

    public Source resolve(URL base, String location, SourceParameters parameters) throws MalformedURLException, IOException, ComponentException {
        String protocol;
        String systemID;
        String string;
        SourceResolverImpl.super.getLogger().debug("Resolving '" + location + "' in context '" + base + "'");
        if (location == null) {
            throw new MalformedURLException("Invalid System ID");
        }
        if (base == null) {
            base = this.baseURL;
        }
        if (location.length() == 0) {
            string = base.toExternalForm();
        } else if (location.indexOf(":") > 1) {
            string = location;
        } else if (location.charAt(0) == '/') {
            string = base.getProtocol() + ":" + location;
        } else if (location.length() > 1 && location.charAt(1) == ':') {
            string = base.getProtocol() + ":/" + location;
        } else if (base.getProtocol().equals("file")) {
            File temp = new File(base.toExternalForm().substring("file:".length()), location);
            String path = temp.getAbsolutePath();
            string = path.charAt(0) != File.separator.charAt(0) ? "file:/" + path : "file:" + path;
        } else {
            systemID = new URL(base, location).toExternalForm();
        }
        SourceResolverImpl.super.getLogger().debug("Resolved to systemID '" + systemID + "'");
        Source source = null;
        int protocolPos = systemID.indexOf(58);
        if (protocolPos != -1 && this.factorySelector.hasComponent((Object)(protocol = systemID.substring(0, protocolPos)))) {
            SourceFactory factory = null;
            try {
                factory = (SourceFactory)this.factorySelector.select((Object)protocol);
                source = factory.getSource(systemID, parameters);
            }
            finally {
                Object var10_12 = null;
                this.factorySelector.release((Component)factory);
            }
        }
        if (source == null) {
            try {
                this.getLogger().debug("Making URL from " + systemID);
                source = new URLSource(new URL(systemID), parameters);
            }
            catch (MalformedURLException mue) {
                this.getLogger().debug("Making URL - MalformedURLException in getURL:", (Throwable)mue);
                this.getLogger().debug("Making URL a File (assuming that it is full path):" + systemID);
                source = new URLSource(new File(systemID).toURL(), parameters);
            }
        }
        if (source instanceof Loggable) {
            ((Loggable)source).setLogger(this.getLogger());
        }
        try {
            if (source instanceof Contextualizable) {
                ((Contextualizable)source).contextualize(this.context);
            }
        }
        catch (ContextException ce) {
            throw new ComponentException("ContextException occured during source resolving.", (Throwable)ce);
        }
        if (source instanceof Composable) {
            ((Composable)source).compose(this.manager);
        }
        return source;
    }

    public void release(Source source) {
        if (source == null) {
            return;
        }
        if (source instanceof Recyclable) {
            ((Recyclable)source).recycle();
        }
        if (source instanceof Disposable) {
            ((Disposable)source).dispose();
        }
    }
}

