/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import javax.servlet.ServletContext;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.log.LogTarget;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.ServletOutputLogTarget;

public final class ServletTargetFactory
extends AbstractTargetFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";

    /*
     * WARNING - void declaration
     */
    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        void sctx;
        String contextkey = this.m_configuration.getAttribute("context-key", "servlet-context");
        Configuration conf_format = configuration.getChild("format");
        Formatter formatter = this.getFormatter(conf_format);
        try {
            ServletContext servletContext = (ServletContext)this.m_context.get((Object)contextkey);
        }
        catch (ContextException ce) {
            throw new ConfigurationException("Cannot find ServletContext object in application context", (Throwable)ce);
        }
        return new ServletOutputLogTarget((ServletContext)sctx);
    }

    protected final Formatter getFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        return new PatternFormatter(format);
    }
}

