/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.excalibur.logger.LogKitManageable;
import org.apache.avalon.excalibur.logger.LogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;

public class ExcaliburComponentManager
extends AbstractLoggable
implements ComponentManager,
Configurable,
Contextualizable,
Initializable,
Disposable,
RoleManageable,
LogKitManageable {
    private final ComponentManager m_parentManager;
    private final ClassLoader m_loader;
    private Context m_context;
    private Map m_componentMapping;
    private Map m_componentHandlers;
    private RoleManager m_roles;
    private LogKitManager m_logkit;
    private boolean m_disposed;
    private boolean m_initialized;

    public void contextualize(Context context) {
        if (this.m_context == null) {
            this.m_context = context;
        }
    }

    public boolean hasComponent(String role) {
        if (!this.m_initialized) {
            return false;
        }
        if (this.m_disposed) {
            return false;
        }
        boolean exists = false;
        try {
            this.release(this.lookup(role));
            exists = true;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return exists;
    }

    public void initialize() {
        ExcaliburComponentManager excaliburComponentManager = this;
        synchronized (excaliburComponentManager) {
            this.m_initialized = true;
            ArrayList keys = new ArrayList(this.m_componentHandlers.keySet());
            int i = 0;
            while (i < keys.size()) {
                block6: {
                    Object key = keys.get(i);
                    ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                    try {
                        handler.initialize();
                    }
                    catch (Exception e) {
                        if (!this.getLogger().isDebugEnabled()) break block6;
                        this.getLogger().debug("Caught an exception trying to initialize of the component handler.", (Throwable)e);
                    }
                }
                ++i;
            }
        }
    }

    public void dispose() {
        ExcaliburComponentManager excaliburComponentManager = this;
        synchronized (excaliburComponentManager) {
            Iterator<Object> keys = this.m_componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.m_componentHandlers.remove(keys.next());
            }
            keyList.clear();
            this.m_disposed = true;
        }
    }

    public Component lookup(String role) throws ComponentException {
        if (!this.m_initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized ComponentManager: " + role);
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot lookup components on a disposed ComponentManager");
        }
        if (role == null) {
            String message = "ComponentManager Attempted to retrieve component with null role.";
            if (this.getLogger().isErrorEnabled()) {
                this.getLogger().error("ComponentManager Attempted to retrieve component with null role.");
            }
            throw new ComponentException("ComponentManager Attempted to retrieve component with null role.");
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(role));
        if (handler == null) {
            if (this.m_parentManager != null) {
                try {
                    return this.m_parentManager.lookup(role);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not find ComponentHandler, attempting to create one for role: " + role);
            }
            try {
                String className = this.m_roles.getDefaultClassNameForRole(role);
                Class<?> componentClass = this.m_loader.loadClass(className);
                DefaultConfiguration configuration = new DefaultConfiguration("", "-");
                handler = ComponentHandler.getComponentHandler(componentClass, (Configuration)configuration, this, this.m_context, this.m_roles, this.m_logkit);
                handler.setLogger(this.getLogger());
                handler.initialize();
            }
            catch (Exception e) {
                throw new ComponentException("ComponentManager Could not find component for role: " + role, (Throwable)e);
            }
            this.m_componentHandlers.put(role, handler);
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (IllegalStateException ise) {
            try {
                handler.initialize();
                component = handler.get();
            }
            catch (Exception e) {
                String message = "Could not access the Component";
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Could not access the Component for role: " + role, (Throwable)e);
                }
                throw new ComponentException("Could not access the Component", (Throwable)e);
            }
        }
        catch (Exception e) {
            String message = "Could not access the Component";
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Could not access the Component for role: " + role, (Throwable)e);
            }
            throw new ComponentException("Could not access the Component", (Throwable)e);
        }
        this.m_componentMapping.put(component, handler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        if (this.m_roles == null) {
            DefaultRoleManager role_info = new DefaultRoleManager();
            role_info.setLogger(this.getLogger());
            role_info.configure(configuration);
            this.m_roles = role_info;
        }
        Configuration[] configurations = configuration.getChildren();
        int i = 0;
        while (i < configurations.length) {
            String type = configurations[i].getName();
            if (!type.equals("role")) {
                String role = configurations[i].getAttribute("role", "");
                String className = configurations[i].getAttribute("class", "");
                if (role.equals("")) {
                    role = this.m_roles.getRoleForName(type);
                }
                if (role != null && !role.equals("")) {
                    if (className.equals("")) {
                        className = this.m_roles.getDefaultClassNameForRole(role);
                    }
                    try {
                        if (this.getLogger().isDebugEnabled()) {
                            this.getLogger().debug("Adding component (" + role + " = " + className + ")");
                        }
                        Class<?> clazz = this.m_loader.loadClass(className);
                        this.addComponent(role, clazz, configurations[i]);
                    }
                    catch (Exception e) {
                        String message = "Could not get class ";
                        if (this.getLogger().isErrorEnabled()) {
                            this.getLogger().error("Could not get class " + className + " for role " + role + " on configuration element " + configurations[i].getName(), (Throwable)e);
                        }
                        throw new ConfigurationException("Could not get class ", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (this.m_roles == null) {
            this.m_roles = roles;
        }
    }

    public void setLogKitManager(LogKitManager logkit) {
        if (this.m_logkit == null) {
            this.m_logkit = logkit;
        }
    }

    public void release(Component component) {
        if (component == null) {
            return;
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
        if (handler != null) {
            block6: {
                try {
                    handler.put(component);
                }
                catch (Exception e) {
                    if (!this.getLogger().isDebugEnabled()) break block6;
                    this.getLogger().debug("Error trying to release component.", (Throwable)e);
                }
            }
            this.m_componentMapping.remove(component);
        } else if (this.m_parentManager != null) {
            this.m_parentManager.release(component);
        }
    }

    public void addComponent(String role, Class component, Configuration configuration) throws ComponentException {
        if (this.m_initialized) {
            throw new ComponentException("Cannot add components to an initialized ComponentManager", null);
        }
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Attempting to get Handler for: " + role);
            }
            ComponentHandler handler = ComponentHandler.getComponentHandler(component, configuration, this, this.m_context, this.m_roles, this.m_logkit);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Handler type = " + ((Object)((Object)handler)).getClass().getName());
            }
            handler.setLogger(this.getLogger());
            this.m_componentHandlers.put(role, handler);
        }
        catch (Exception e) {
            throw new ComponentException("Could not set up Component for role: " + role, (Throwable)e);
        }
    }

    public void addComponentInstance(String role, Component instance) {
        block3: {
            if (this.m_initialized) {
                throw new IllegalStateException("Cannot add components to an initialized ComponentManager");
            }
            try {
                ComponentHandler handler = ComponentHandler.getComponentHandler(instance);
                handler.setLogger(this.getLogger());
                this.m_componentHandlers.put(role, handler);
            }
            catch (Exception e) {
                if (!this.getLogger().isWarnEnabled()) break block3;
                this.getLogger().warn("Could not set up Component for role: " + role, (Throwable)e);
            }
        }
    }

    public ExcaliburComponentManager() {
        this(null, Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentManager(ClassLoader loader) {
        this(null, loader);
    }

    public ExcaliburComponentManager(ComponentManager manager, ClassLoader loader) {
        this.m_loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        this.m_parentManager = manager;
        this.m_componentHandlers = Collections.synchronizedMap(new HashMap());
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }

    public ExcaliburComponentManager(ComponentManager manager) {
        this(manager, Thread.currentThread().getContextClassLoader());
    }
}

