/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Hashtable;
import org.apache.log.Category;
import org.apache.log.ContextStack;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.output.DefaultOutputLogTarget;

public final class LogKit {
    protected static final Hashtable c_contexts = new Hashtable();
    protected static final Hashtable c_loggers = new Hashtable();
    protected static final Hashtable c_categories = new Hashtable();
    protected static final Hashtable c_logTargets;
    protected static Priority.Enum c_priority;
    protected static LogTarget c_defaultLogTarget;

    public static void addLogTarget(String string, LogTarget logTarget) {
        if (string.equals("default")) {
            c_defaultLogTarget = logTarget;
        }
        c_logTargets.put(string, logTarget);
    }

    public static LogTarget getLogTarget(String string) {
        return (LogTarget)c_logTargets.get(string);
    }

    public static Category createCategory(String string, Priority.Enum enum_) {
        Category category = (Category)c_categories.get(string);
        if (null == category) {
            category = new Category(string);
            c_categories.put(string, category);
        }
        category.setPriority(enum_);
        return category;
    }

    public static Logger createLogger(Category category) {
        return LogKit.createLogger(category, null);
    }

    public static Logger createLogger(Category category, LogTarget[] logTargetArray) {
        String string = category.getName();
        Logger logger = (Logger)c_loggers.get(string);
        if (null == logger) {
            int n = string.lastIndexOf(46);
            Logger logger2 = null;
            if (-1 != n) {
                String string2 = string.substring(0, n);
                logger2 = LogKit.getLoggerFor(string2);
            }
            logger = new Logger(category, logTargetArray, logger2);
            c_loggers.put(string, logger);
        } else if (null != logTargetArray) {
            logger.setLogTargets(logTargetArray);
        }
        return logger;
    }

    public static ContextStack getCurrentContext() {
        Thread thread = Thread.currentThread();
        ContextStack contextStack = (ContextStack)c_contexts.get(thread);
        if (null == contextStack) {
            contextStack = new ContextStack();
            contextStack.push(thread.getName());
            c_contexts.put(thread, contextStack);
        }
        return contextStack;
    }

    public static LogTarget getDefaultLogTarget() {
        return c_defaultLogTarget;
    }

    public static Priority.Enum getGlobalPriority() {
        return c_priority;
    }

    public static Logger getLoggerFor(String string) {
        Hashtable hashtable = c_loggers;
        synchronized (hashtable) {
            Logger logger = (Logger)c_loggers.get(string);
            if (null == logger) {
                logger = LogKit.createLogger(LogKit.createCategory(string, Priority.DEBUG));
            }
            Logger logger2 = logger;
            return logger2;
        }
    }

    public static Priority.Enum getPriorityForName(String string) {
        if (Priority.DEBUG.getName().equals(string)) {
            return Priority.DEBUG;
        }
        if (Priority.INFO.getName().equals(string)) {
            return Priority.INFO;
        }
        if (Priority.WARN.getName().equals(string)) {
            return Priority.WARN;
        }
        if (Priority.ERROR.getName().equals(string)) {
            return Priority.ERROR;
        }
        if (Priority.FATAL_ERROR.getName().equals(string)) {
            return Priority.FATAL_ERROR;
        }
        return Priority.DEBUG;
    }

    public static void log(String string, Throwable throwable) {
        System.err.println("Error: " + string);
        throwable.printStackTrace();
    }

    public static void log(String string) {
        System.err.println("Error: " + string);
    }

    public static void setDefaultLogTarget(LogTarget logTarget) {
        LogKit.addLogTarget("default", logTarget);
        c_defaultLogTarget = logTarget;
    }

    public static void setGlobalPriority(Priority.Enum enum_) {
        c_priority = enum_;
    }

    private LogKit() {
    }

    static {
        c_priority = Priority.DEBUG;
        c_logTargets = new Hashtable();
        c_defaultLogTarget = new DefaultOutputLogTarget();
        c_logTargets.put("default", c_defaultLogTarget);
    }
}

