/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.rmic;

import java.io.File;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Rmic;
import org.apache.tools.ant.taskdefs.rmic.RmicAdapter;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.util.FileNameMapper;
import org.apache.tools.ant.util.GlobPatternMapper;

public abstract class DefaultRmicAdapter
implements RmicAdapter {
    private Rmic attributes;
    private FileNameMapper mapper;

    public void setRmic(Rmic rmic) {
        this.attributes = rmic;
        this.mapper = new RmicFileNameMapper();
    }

    public Rmic getRmic() {
        return this.attributes;
    }

    public String getStubClassSuffix() {
        return "_Stub";
    }

    public String getSkelClassSuffix() {
        return "_Skel";
    }

    public FileNameMapper getMapper() {
        return this.mapper;
    }

    public Path getClasspath() {
        return this.getCompileClasspath();
    }

    protected Path getCompileClasspath() {
        Path path = new Path(this.attributes.getProject());
        path.setLocation(this.attributes.getBase());
        if (this.attributes.getClasspath() == null) {
            if (this.attributes.getIncludeantruntime()) {
                path.addExisting(Path.systemClasspath);
            }
        } else if (this.attributes.getIncludeantruntime()) {
            path.addExisting(this.attributes.getClasspath().concatSystemClasspath("last"));
        } else {
            path.addExisting(this.attributes.getClasspath().concatSystemClasspath("ignore"));
        }
        if (this.attributes.getIncludejavaruntime()) {
            if (System.getProperty("java.vendor").toLowerCase().indexOf("microsoft") >= 0) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(System.getProperty("java.home") + File.separator + "Packages"));
                fileSet.setIncludes("*.ZIP");
                path.addFileset(fileSet);
            } else if (Project.getJavaVersion() == "1.1") {
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "classes.zip"));
            } else if (System.getProperty("java.vm.name").equals("Kaffe")) {
                FileSet fileSet = new FileSet();
                fileSet.setDir(new File(System.getProperty("java.home") + File.separator + "share" + File.separator + "kaffe"));
                fileSet.setIncludes("*.jar");
                path.addFileset(fileSet);
            } else {
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "lib" + File.separator + "rt.jar"));
                path.addExisting(new Path(null, System.getProperty("java.home") + File.separator + "jre" + File.separator + "lib" + File.separator + "rt.jar"));
            }
        }
        return path;
    }

    protected Commandline setupRmicCommand() {
        return this.setupRmicCommand(null);
    }

    protected Commandline setupRmicCommand(String[] stringArray) {
        Commandline commandline = new Commandline();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                commandline.createArgument().setValue(stringArray[n]);
                ++n;
            }
        }
        Path path = this.getCompileClasspath();
        commandline.createArgument().setValue("-d");
        commandline.createArgument().setFile(this.attributes.getBase());
        if (this.attributes.getExtdirs() != null) {
            if (Project.getJavaVersion().startsWith("1.1")) {
                this.addExtdirsToClasspath(path);
            } else {
                commandline.createArgument().setValue("-extdirs");
                commandline.createArgument().setPath(this.attributes.getExtdirs());
            }
        }
        commandline.createArgument().setValue("-classpath");
        commandline.createArgument().setPath(path);
        String string = this.attributes.getStubVersion();
        if (null != string) {
            if ("1.1".equals(string)) {
                commandline.createArgument().setValue("-v1.1");
            } else if ("1.2".equals(string)) {
                commandline.createArgument().setValue("-v1.2");
            } else {
                commandline.createArgument().setValue("-vcompat");
            }
        }
        if (null != this.attributes.getSourceBase()) {
            commandline.createArgument().setValue("-keepgenerated");
        }
        if (this.attributes.getIiop()) {
            this.attributes.log("IIOP has been turned on.", 2);
            commandline.createArgument().setValue("-iiop");
            if (this.attributes.getIiopopts() != null) {
                this.attributes.log("IIOP Options: " + this.attributes.getIiopopts(), 2);
                commandline.createArgument().setValue(this.attributes.getIiopopts());
            }
        }
        if (this.attributes.getIdl()) {
            commandline.createArgument().setValue("-idl");
            this.attributes.log("IDL has been turned on.", 2);
            if (this.attributes.getIdlopts() != null) {
                commandline.createArgument().setValue(this.attributes.getIdlopts());
                this.attributes.log("IDL Options: " + this.attributes.getIdlopts(), 2);
            }
        }
        if (this.attributes.getDebug()) {
            commandline.createArgument().setValue("-g");
        }
        this.logAndAddFilesToCompile(commandline);
        return commandline;
    }

    protected void logAndAddFilesToCompile(Commandline commandline) {
        Vector vector = this.attributes.getCompileList();
        this.attributes.log("Compilation args: " + commandline.toString(), 3);
        StringBuffer stringBuffer = new StringBuffer("File");
        if (vector.size() != 1) {
            stringBuffer.append("s");
        }
        stringBuffer.append(" to be compiled:");
        int n = 0;
        while (n < vector.size()) {
            String string = (String)vector.elementAt(n);
            commandline.createArgument().setValue(string);
            stringBuffer.append("    " + string);
            ++n;
        }
        this.attributes.log(stringBuffer.toString(), 3);
    }

    protected void addExtdirsToClasspath(Path path) {
        String[] stringArray;
        Path path2 = this.attributes.getExtdirs();
        if (path2 == null) {
            stringArray = System.getProperty("java.ext.dirs");
            if (stringArray != null) {
                path2 = new Path(this.attributes.getProject(), (String)stringArray);
            } else {
                return;
            }
        }
        stringArray = path2.list();
        int n = 0;
        while (n < stringArray.length) {
            if (!stringArray[n].endsWith(File.separator)) {
                int n2 = n;
                stringArray[n2] = stringArray[n2] + File.separator;
            }
            File file = this.attributes.getProject().resolveFile(stringArray[n]);
            FileSet fileSet = new FileSet();
            fileSet.setDir(file);
            fileSet.setIncludes("*");
            path.addFileset(fileSet);
            ++n;
        }
    }

    public abstract boolean execute() throws BuildException;

    private class RmicFileNameMapper
    implements FileNameMapper {
        private GlobPatternMapper stubMapper = new GlobPatternMapper();
        private GlobPatternMapper skelMapper;

        RmicFileNameMapper() {
            this.stubMapper.setFrom("*.class");
            this.stubMapper.setTo("*" + DefaultRmicAdapter.this.getStubClassSuffix() + ".class");
            if (!"1.2".equals(DefaultRmicAdapter.this.attributes.getStubVersion())) {
                this.skelMapper = new GlobPatternMapper();
                this.skelMapper.setFrom("*.class");
                this.skelMapper.setTo("*" + DefaultRmicAdapter.this.getSkelClassSuffix() + ".class");
            }
        }

        public void setFrom(String string) {
        }

        public void setTo(String string) {
        }

        public String[] mapFileName(String string) {
            String[] stringArray = this.stubMapper.mapFileName(string);
            if (stringArray == null || string.endsWith(DefaultRmicAdapter.this.getStubClassSuffix() + ".class") || string.endsWith(DefaultRmicAdapter.this.getSkelClassSuffix() + ".class")) {
                return null;
            }
            String string2 = string.replace(File.separatorChar, '.');
            string2 = string2.substring(0, string2.indexOf(".class"));
            if (DefaultRmicAdapter.this.attributes.getVerify() && !DefaultRmicAdapter.this.attributes.isValidRmiRemote(string2)) {
                return null;
            }
            if (this.skelMapper != null) {
                return new String[]{stringArray[0], this.skelMapper.mapFileName(string)[0]};
            }
            return stringArray;
        }
    }
}

