/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.component;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.excalibur.component.ComponentHandler;
import org.apache.avalon.excalibur.component.RoleManageable;
import org.apache.avalon.excalibur.component.RoleManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.Component;
import org.apache.avalon.framework.component.ComponentException;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.ComponentSelector;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public class ExcaliburComponentSelector
extends AbstractLoggable
implements Contextualizable,
ComponentSelector,
Composable,
Configurable,
Initializable,
ThreadSafe,
Disposable,
RoleManageable {
    private static final String DEFAULT_NAME = "UnnamedSelector";
    private final ClassLoader m_loader;
    private String m_rolename;
    protected Context m_context;
    private ComponentManager m_componentManager;
    private Map m_componentMapping;
    private Configuration m_configuration;
    private Map m_componentHandlers;
    private boolean m_disposed;
    private boolean m_initialized;
    private RoleManager m_roles;

    public void contextualize(Context context) {
        if (this.m_context == null) {
            this.m_context = context;
        }
    }

    public void compose(ComponentManager componentManager) throws ComponentException {
        if (this.m_componentManager == null) {
            this.m_componentManager = componentManager;
        }
    }

    public void initialize() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            this.m_initialized = true;
            ArrayList keys = new ArrayList(this.m_componentHandlers.keySet());
            int i = 0;
            while (i < keys.size()) {
                Object key = keys.get(i);
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                try {
                    handler.initialize();
                }
                catch (Exception e) {
                    this.getLogger().debug("Caught an exception trying to initialize of the component handler.", (Throwable)e);
                }
                ++i;
            }
        }
    }

    public void dispose() {
        ExcaliburComponentSelector excaliburComponentSelector = this;
        synchronized (excaliburComponentSelector) {
            Iterator<Object> keys = this.m_componentHandlers.keySet().iterator();
            ArrayList keyList = new ArrayList();
            while (keys.hasNext()) {
                Object key = keys.next();
                ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(key));
                handler.dispose();
                keyList.add(key);
            }
            keys = keyList.iterator();
            while (keys.hasNext()) {
                this.m_componentHandlers.remove(keys.next());
            }
            keyList.clear();
            this.m_disposed = true;
        }
    }

    public Component select(Object hint) throws ComponentException {
        if (!this.m_initialized && this.getLogger().isWarnEnabled()) {
            this.getLogger().warn("Looking up component on an uninitialized ComponentManager: " + hint);
        }
        if (this.m_disposed) {
            throw new IllegalStateException("You cannot select a Component from a disposed ComponentSelector");
        }
        if (hint == null) {
            String message = this.getName() + ": ComponentSelector Attempted " + "to retrieve component with null hint.";
            this.getLogger().error(message);
            throw new ComponentException(message);
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentHandlers.get(hint));
        if (handler == null) {
            String message = this.getName() + ": ComponentSelector could not " + "find the component for hint: " + hint;
            this.getLogger().debug(message);
            throw new ComponentException(message);
        }
        Component component = null;
        try {
            component = handler.get();
        }
        catch (Exception e) {
            String message = this.getName() + ": ComponentSelector could not " + "access the Component for hint: " + hint;
            this.getLogger().debug(message, (Throwable)e);
            throw new ComponentException(message, (Throwable)e);
        }
        if (component == null) {
            String message = this.getName() + ": ComponentSelector could not " + "find the component for hint: " + hint;
            this.getLogger().debug(message);
            throw new ComponentException(message);
        }
        this.m_componentMapping.put(component, handler);
        return component;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.m_configuration = configuration;
        this.getLogger().debug("ComponentSelector setting up with root element: " + this.m_configuration.getName());
        String name = configuration.getName();
        this.m_rolename = name.equals("component") ? this.m_configuration.getAttribute("role") : this.m_roles.getRoleForName(name);
        Configuration[] instances = this.m_configuration.getChildren();
        int i = 0;
        while (i < instances.length) {
            String className;
            String hint = instances[i].getAttribute("name").trim();
            if ("component-instance".equals(instances[i].getName())) {
                String string = instances[i].getAttribute("class").trim();
            } else {
                className = this.m_roles.getDefaultClassNameForHint(this.m_rolename, instances[i].getName());
            }
            try {
                Class<?> clazz = this.m_loader.loadClass(className);
                this.addComponent(hint, clazz, instances[i]);
            }
            catch (Exception e) {
                String message = "The component instance for '" + hint + "' has an invalid class name.";
                this.getLogger().error(message, (Throwable)e);
                throw new ConfigurationException(message, (Throwable)e);
            }
            ++i;
        }
    }

    public void setRoleManager(RoleManager roles) {
        if (this.m_roles == null) {
            this.m_roles = roles;
        }
    }

    public void release(Component component) {
        if (component == null) {
            return;
        }
        ComponentHandler handler = (ComponentHandler)((Object)this.m_componentMapping.get(component));
        if (handler == null) {
            return;
        }
        try {
            handler.put(component);
        }
        catch (Exception e) {
            this.getLogger().debug("Error trying to release component", (Throwable)e);
        }
        this.m_componentMapping.remove(component);
    }

    public void addComponent(Object hint, Class component, Configuration configuration) throws ComponentException {
        if (this.m_initialized) {
            throw new ComponentException("Cannot add components to an initialized ComponentSelector", null);
        }
        try {
            ComponentHandler handler = ComponentHandler.getComponentHandler(component, configuration, this.m_componentManager, this.m_context, this.m_roles);
            handler.setLogger(this.getLogger());
            handler.initialize();
            this.m_componentHandlers.put(hint, handler);
            this.getLogger().debug("Adding " + component.getName() + " for " + hint.toString());
        }
        catch (Exception e) {
            String message = "Could not set up Component for hint: " + hint;
            this.getLogger().error(message, (Throwable)e);
            throw new ComponentException(message, (Throwable)e);
        }
    }

    public void addComponentInstance(String hint, Object instance) {
        if (this.m_initialized) {
            throw new IllegalStateException("Cannot add components to an initialized ComponentSelector");
        }
        try {
            ComponentHandler handler = ComponentHandler.getComponentHandler((Component)instance);
            handler.setLogger(this.getLogger());
            handler.initialize();
            this.m_componentHandlers.put(hint, handler);
            this.getLogger().debug("Adding " + instance.getClass().getName() + " for " + hint.toString());
        }
        catch (Exception e) {
            this.getLogger().error("Could not set up Component for hint: " + hint, (Throwable)e);
        }
    }

    private String getName() {
        if (this.m_configuration != null && !this.m_configuration.getName().equals("")) {
            return this.m_configuration.getName();
        }
        return DEFAULT_NAME;
    }

    public ExcaliburComponentSelector() {
        this(Thread.currentThread().getContextClassLoader());
    }

    public ExcaliburComponentSelector(ClassLoader loader) {
        this.m_loader = loader == null ? Thread.currentThread().getContextClassLoader() : loader;
        this.m_componentHandlers = Collections.synchronizedMap(new HashMap());
        this.m_componentMapping = Collections.synchronizedMap(new HashMap());
    }
}

