/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Random;
import java.util.ResourceBundle;

public class ResourceGroup {
    protected static final Random RANDOM = new Random();
    protected final HashMap m_bundles = new HashMap();
    protected final Locale m_locale;

    public Locale getLocale() {
        return this.m_locale;
    }

    public String format(String base, String key, Object[] args) {
        String pattern = this.getPattern(base, key);
        MessageFormat messageFormat = new MessageFormat(pattern);
        messageFormat.setLocale(this.m_locale);
        return messageFormat.format(args);
    }

    public ResourceBundle getBundle(String base) throws MissingResourceException {
        ResourceBundle result = (ResourceBundle)this.m_bundles.get(base);
        if (result != null) {
            return result;
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        result = ResourceBundle.getBundle(base, this.m_locale, classLoader);
        this.m_bundles.put(base, result);
        return result;
    }

    public String getPattern(String base, String key) throws MissingResourceException {
        ResourceBundle bundle = this.getBundle(base);
        Object object = bundle.getObject(key);
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] strings = (String[])object;
            return strings[RANDOM.nextInt(strings.length)];
        }
        throw new MissingResourceException("Unable to find resource of appropriate type.", "java.lang.String", key);
    }

    public ResourceGroup(Locale locale) {
        this.m_locale = locale;
    }
}

