/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.camelot;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.DefaultConfigurationBuilder;
import org.apache.avalon.camelot.DeploymentException;
import org.xml.sax.SAXException;

public final class DeployerUtil {
    protected static DefaultConfigurationBuilder c_configurationBuilder;

    protected static DefaultConfigurationBuilder getBuilder() {
        if (c_configurationBuilder == null) {
            c_configurationBuilder = new DefaultConfigurationBuilder();
        }
        return c_configurationBuilder;
    }

    public static final ZipFile getZipFileFor(File file) throws DeploymentException {
        try {
            return new ZipFile(file);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error opening " + file + " due to " + ioe.getMessage(), ioe);
        }
    }

    public static final Configuration loadConfiguration(ZipFile zipFile, String filename) throws DeploymentException {
        return DeployerUtil.buildConfiguration(DeployerUtil.loadResourceStream(zipFile, filename));
    }

    public static final Configuration buildConfiguration(InputStream input) throws DeploymentException {
        try {
            return DeployerUtil.getBuilder().build(input);
        }
        catch (SAXException se) {
            throw new DeploymentException("Malformed configuration data", se);
        }
        catch (ConfigurationException ce) {
            throw new DeploymentException("Error building configuration", ce);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading configuration", ioe);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Manifest loadManifest(ZipFile zipFile) throws DeploymentException {
        InputStream input = DeployerUtil.loadResourceStream(zipFile, "META-INF/MANIFEST.MF");
        try {
            try {
                Manifest manifest = new Manifest(input);
                Object var3_3 = null;
                try {
                    input.close();
                    return manifest;
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                return manifest;
            }
            catch (IOException ioe) {
                throw new DeploymentException("Error reading manifest", ioe);
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            try {}
            catch (IOException ioe) {
                throw throwable;
            }
            input.close();
            throw throwable;
        }
    }

    public static final Properties loadProperties(ZipFile zipFile, String filename) throws DeploymentException {
        Properties properties = new Properties();
        try {
            properties.load(DeployerUtil.loadResourceStream(zipFile, filename));
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading " + filename + " from " + zipFile.getName(), ioe);
        }
        return properties;
    }

    public static final InputStream loadResourceStream(ZipFile zipFile, String filename) throws DeploymentException {
        ZipEntry entry = zipFile.getEntry(filename);
        if (entry == null) {
            throw new DeploymentException("Unable to locate " + filename + " in " + zipFile.getName());
        }
        try {
            return zipFile.getInputStream(entry);
        }
        catch (IOException ioe) {
            throw new DeploymentException("Error reading " + filename + " from " + zipFile.getName(), ioe);
        }
    }

    private DeployerUtil() {
    }
}

