/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xalan.templates;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.TransformerException;
import org.apache.xalan.res.XSLMessages;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.StylesheetRoot;
import org.apache.xml.utils.QName;
import org.apache.xml.utils.SAXSourceLocator;
import org.apache.xpath.Expression;
import org.apache.xpath.XPathContext;
import org.apache.xpath.functions.Function3Args;
import org.apache.xpath.functions.WrongNumberArgsException;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.objects.XString;

public class FuncFormatNumb
extends Function3Args {
    public XObject execute(XPathContext xctxt) throws TransformerException {
        ElemTemplateElement templElem = (ElemTemplateElement)xctxt.getNamespaceContext();
        StylesheetRoot ss = templElem.getStylesheetRoot();
        NumberFormat formatter = null;
        DecimalFormatSymbols dfs = null;
        double num = this.getArg0().execute(xctxt).num();
        String patternStr = this.getArg1().execute(xctxt).str();
        if (patternStr.indexOf(164) > 0) {
            ss.error(82);
        }
        try {
            Expression arg2Expr = this.getArg2();
            if (null != arg2Expr) {
                String dfName = arg2Expr.execute(xctxt).str();
                QName qname = new QName(dfName, xctxt.getNamespaceContext());
                dfs = ss.getDecimalFormatComposed(qname);
                if (null == dfs) {
                    this.warn(xctxt, 17, new Object[]{dfName});
                } else {
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                }
            }
            if (null == formatter) {
                if (ss.getDecimalFormatCount() > 0) {
                    dfs = ss.getDecimalFormatComposed(new QName(""));
                }
                if (dfs != null) {
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                } else {
                    dfs = new DecimalFormatSymbols(Locale.US);
                    dfs.setInfinity("Infinity");
                    dfs.setNaN("NaN");
                    formatter = new DecimalFormat();
                    ((DecimalFormat)formatter).setDecimalFormatSymbols(dfs);
                    if (null != patternStr) {
                        ((DecimalFormat)formatter).applyLocalizedPattern(patternStr);
                    }
                }
            }
            return new XString(formatter.format(num));
        }
        catch (Exception iae) {
            templElem.error(91, new Object[]{patternStr});
            return XString.EMPTYSTRING;
        }
    }

    public void warn(XPathContext xctxt, int msg, Object[] args) throws TransformerException {
        String formattedMsg = XSLMessages.createWarning(msg, args);
        ErrorListener errHandler = xctxt.getErrorListener();
        errHandler.warning(new TransformerException(formattedMsg, (SAXSourceLocator)xctxt.getSAXLocator()));
    }

    public void checkNumberArgs(int argNum) throws WrongNumberArgsException {
        if (argNum > 3 || argNum < 2) {
            throw new WrongNumberArgsException(XSLMessages.createMessage(142, null));
        }
    }
}

