/*
 * Decompiled with CFR 0.152.
 */
package org.apache.crimson.tree;

import org.apache.crimson.tree.Doctype;
import org.apache.crimson.tree.DomEx;
import org.apache.crimson.tree.XmlDocument;
import org.apache.crimson.util.XmlNames;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

public class DOMImplementationImpl
implements DOMImplementation {
    private static DOMImplementationImpl singleton = new DOMImplementationImpl();

    public static DOMImplementation getDOMImplementation() {
        return singleton;
    }

    public boolean hasFeature(String feature, String version) {
        return DOMImplementationImpl.hasFeature0(feature, version);
    }

    static boolean hasFeature0(String feature, String version) {
        return !(!"XML".equalsIgnoreCase(feature) && !"Core".equalsIgnoreCase(feature) || version != null && !"".equals(version) && !"2.0".equals(version) && !"1.0".equals(version));
    }

    public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
        if (!XmlNames.isName(qualifiedName)) {
            throw new DomEx(5);
        }
        if (!XmlNames.isQualifiedName(qualifiedName)) {
            throw new DomEx(14);
        }
        return new Doctype(qualifiedName, publicId, systemId, null);
    }

    public Document createDocument(String namespaceURI, String qualifiedName, DocumentType doctype) throws DOMException {
        XmlDocument doc = new XmlDocument();
        if (doctype != null) {
            doc.appendChild(doctype);
        }
        Element docElement = doc.createElementNS(namespaceURI, qualifiedName);
        doc.appendChild(docElement);
        return doc;
    }
}

