/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.factory;

import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.avalon.excalibur.logger.factory.AbstractTargetFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.context.ContextException;
import org.apache.log.LogTarget;
import org.apache.log.format.ExtendedPatternFormatter;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.format.RawFormatter;
import org.apache.log.output.io.FileTarget;
import org.apache.log.output.io.rotate.FileStrategy;
import org.apache.log.output.io.rotate.OrRotateStrategy;
import org.apache.log.output.io.rotate.RevolvingFileStrategy;
import org.apache.log.output.io.rotate.RotateStrategy;
import org.apache.log.output.io.rotate.RotateStrategyBySize;
import org.apache.log.output.io.rotate.RotateStrategyByTime;
import org.apache.log.output.io.rotate.RotatingFileTarget;
import org.apache.log.output.io.rotate.UniqueFileStrategy;

public class FileTargetFactory
extends AbstractTargetFactory {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";
    private static final long SECOND = 1000L;
    private static final long MINUTE = 60000L;
    private static final long HOUR = 3600000L;
    private static final long DAY = 86400000L;
    private static final long KILOBYTE = 1000L;
    private static final long MEGABYTE = 1000000L;

    /*
     * WARNING - void declaration
     */
    public final LogTarget createTarget(Configuration configuration) throws ConfigurationException {
        void logtarget;
        Configuration conf_filename = configuration.getChild("filename");
        String filename = this.getFilename(conf_filename.getValue());
        Configuration conf_rotation = configuration.getChild("rotation", false);
        Configuration conf_format = configuration.getChild("format");
        Configuration conf_append = configuration.getChild("append");
        boolean append = conf_append.getValueAsBoolean(false);
        File file = new File(filename);
        Formatter formatter = this.getFormatter(conf_format);
        try {
            FileTarget fileTarget;
            if (conf_rotation == null) {
                fileTarget = new FileTarget(file, append, formatter);
            } else {
                Configuration conf_strategy = conf_rotation.getChildren()[0];
                RotateStrategy rotateStrategy = this.getRotateStrategy(conf_strategy);
                FileStrategy fileStrategy = this.getFileStrategy(conf_rotation, file);
                fileTarget = new RotatingFileTarget(formatter, rotateStrategy, fileStrategy);
            }
        }
        catch (IOException ioe) {
            throw new ConfigurationException("cannot create FileTarget", (Throwable)ioe);
        }
        return logtarget;
    }

    private final RotateStrategy getRotateStrategy(Configuration conf) {
        String type = conf.getName();
        if ("or".equals(type)) {
            Configuration[] configurations = conf.getChildren();
            int size = configurations.length;
            RotateStrategy[] strategies = new RotateStrategy[size];
            int i = 0;
            while (i < size) {
                strategies[i] = this.getRotateStrategy(configurations[i]);
                ++i;
            }
            return new OrRotateStrategy(strategies);
        }
        if ("size".equals(type)) {
            long size;
            String value = conf.getValue("2m");
            int count = value.length();
            char end = value.charAt(count - 1);
            switch (end) {
                case 'm': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000000L;
                    break;
                }
                case 'k': {
                    long no = Long.parseLong(value.substring(0, count - 1));
                    size = no * 1000L;
                    break;
                }
                default: {
                    size = Long.parseLong(value);
                }
            }
            return new RotateStrategyBySize(size);
        }
        String value = conf.getValue("24:00:00");
        StringTokenizer tokenizer = new StringTokenizer(value, ":");
        int count = tokenizer.countTokens();
        long time = 0L;
        int i = count;
        while (i > 0) {
            long no = Long.parseLong(tokenizer.nextToken());
            if (4 == i) {
                time += no * 86400000L;
            }
            if (3 == i) {
                time += no * 3600000L;
            }
            if (2 == i) {
                time += no * 60000L;
            }
            if (1 == i) {
                time += no * 1000L;
            }
            --i;
        }
        return new RotateStrategyByTime(time);
    }

    protected FileStrategy getFileStrategy(Configuration conf, File file) {
        String type = conf.getAttribute("type", "unique");
        if ("revolving".equals(type)) {
            int initialRotation = conf.getAttributeAsInteger("init", 5);
            int maxRotation = conf.getAttributeAsInteger("max", 10);
            return new RevolvingFileStrategy(file, initialRotation, maxRotation);
        }
        return new UniqueFileStrategy(file);
    }

    protected Formatter getFormatter(Configuration conf) {
        String type = conf.getAttribute("type", "pattern");
        String format = conf.getValue(FORMAT);
        if ("extended".equals(type)) {
            return new ExtendedPatternFormatter(format);
        }
        if ("raw".equals(type)) {
            return new RawFormatter();
        }
        return new PatternFormatter(format);
    }

    /*
     * WARNING - void declaration
     */
    protected final String getFilename(String rawFilename) throws ConfigurationException {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int j = -1;
        while ((j = rawFilename.indexOf("${", i)) > -1) {
            void ctx;
            if (i < j) {
                sb.append(rawFilename.substring(i, j));
            }
            int k = rawFilename.indexOf(125, j);
            String ctx_name = rawFilename.substring(j + 2, k);
            try {
                Object object = this.m_context.get((Object)ctx_name);
            }
            catch (ContextException ce) {
                throw new ConfigurationException("missing entry '" + ctx_name + "' in Context");
            }
            sb.append(ctx.toString());
            i = k + 1;
        }
        if (i < rawFilename.length()) {
            sb.append(rawFilename.substring(i, rawFilename.length()));
        }
        return sb.toString();
    }
}

