/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.catalog;

import java.io.DataInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.avalon.excalibur.catalog.CatalogEntry;
import org.apache.avalon.excalibur.catalog.InvalidCatalogEntryException;
import org.apache.avalon.excalibur.catalog.InvalidCatalogEntryTypeException;

public class CatalogReader {
    public int debug = 0;
    private String catfilename = null;
    private DataInputStream catfile = null;
    private int[] stack = new int[3];
    private int top = -1;

    public CatalogReader() {
        String property = System.getProperty("xml.catalog.debug");
        if (property != null) {
            try {
                this.debug = Integer.parseInt(property);
            }
            catch (NumberFormatException e) {
                this.debug = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String normalize(String publicId) {
        int pos;
        String normal = publicId.replace('\t', ' ');
        normal = normal.replace('\r', ' ');
        normal = normal.replace('\n', ' ');
        normal = normal.trim();
        while ((pos = normal.indexOf("  ")) >= 0) {
            void var2_2;
            normal = normal.substring(0, (int)var2_2) + normal.substring((int)(var2_2 + true));
        }
        return normal;
    }

    public void parseCatalog(String fileUrl) throws MalformedURLException, IOException {
        URL catalog;
        this.catfilename = fileUrl;
        try {
            catalog = new URL(fileUrl);
        }
        catch (MalformedURLException e) {
            catalog = new URL("file:///" + fileUrl);
        }
        try {
            this.catfile = new DataInputStream(catalog.openStream());
        }
        catch (FileNotFoundException e) {
            this.debug(1, "Failed to load catalog, file not found", catalog.toString());
        }
    }

    public CatalogEntry nextEntry() throws IOException {
        if (this.catfile == null) {
            return null;
        }
        boolean confused = false;
        while (true) {
            String token;
            if ((token = this.nextToken()) == null) {
                this.catfile.close();
                this.catfile = null;
                return null;
            }
            if (token.equalsIgnoreCase("BASE") || token.equalsIgnoreCase("CATALOG") || token.equalsIgnoreCase("DOCUMENT") || token.equalsIgnoreCase("OVERRIDE") || token.equalsIgnoreCase("SGMLDECL")) {
                String spec = this.nextToken();
                confused = false;
                try {
                    if (token.equalsIgnoreCase("BASE")) {
                        return new CatalogEntry(1, spec);
                    }
                    if (token.equalsIgnoreCase("CATALOG")) {
                        return new CatalogEntry(2, spec);
                    }
                    if (token.equalsIgnoreCase("DOCUMENT")) {
                        return new CatalogEntry(3, spec);
                    }
                    if (token.equalsIgnoreCase("OVERRIDE")) {
                        return new CatalogEntry(4, spec);
                    }
                    if (token.equalsIgnoreCase("SGMLDECL")) {
                        return new CatalogEntry(5, spec);
                    }
                }
                catch (InvalidCatalogEntryTypeException icete) {
                    this.debug(1, "Invalid catalog entry type", token);
                    confused = true;
                }
                catch (InvalidCatalogEntryException icete) {
                    this.debug(1, "Invalid catalog entry", token, spec);
                    confused = true;
                }
            }
            if (token.equalsIgnoreCase("DELEGATE") || token.equalsIgnoreCase("DOCTYPE") || token.equalsIgnoreCase("DTDDECL") || token.equalsIgnoreCase("ENTITY") || token.equalsIgnoreCase("LINKTYPE") || token.equalsIgnoreCase("NOTATION") || token.equalsIgnoreCase("PUBLIC") || token.equalsIgnoreCase("SYSTEM")) {
                String spec1 = this.nextToken();
                String spec2 = this.nextToken();
                confused = false;
                try {
                    if (token.equalsIgnoreCase("DELEGATE")) {
                        return new CatalogEntry(6, CatalogReader.normalize(spec1), spec2);
                    }
                    if (token.equalsIgnoreCase("DOCTYPE")) {
                        return new CatalogEntry(7, spec1, spec2);
                    }
                    if (token.equalsIgnoreCase("DTDDECL")) {
                        return new CatalogEntry(8, CatalogReader.normalize(spec1), spec2);
                    }
                    if (token.equalsIgnoreCase("ENTITY")) {
                        return new CatalogEntry(9, spec1, spec2);
                    }
                    if (token.equalsIgnoreCase("LINKTYPE")) {
                        return new CatalogEntry(10, spec1, spec2);
                    }
                    if (token.equalsIgnoreCase("NOTATION")) {
                        return new CatalogEntry(11, spec1, spec2);
                    }
                    if (token.equalsIgnoreCase("PUBLIC")) {
                        return new CatalogEntry(12, CatalogReader.normalize(spec1), spec2);
                    }
                    if (token.equalsIgnoreCase("SYSTEM")) {
                        return new CatalogEntry(13, spec1, spec2);
                    }
                }
                catch (InvalidCatalogEntryTypeException icete) {
                    this.debug(1, "Invalid catalog entry type", token);
                    confused = true;
                }
                catch (InvalidCatalogEntryException icete) {
                    this.debug(1, "Invalid catalog entry", token, spec1, spec2);
                    confused = true;
                }
            }
            if (confused) continue;
            if (this.debug > 1) {
                System.out.println("Unrecognized token parsing catalog: '" + this.catfilename + "': " + token);
                System.out.println("\tSkipping to next recognized token.");
            }
            confused = true;
        }
    }

    protected void finalize() throws IOException {
        if (this.catfile != null) {
            this.catfile.close();
        }
        this.catfile = null;
    }

    /*
     * Unable to fully structure code
     */
    private String nextToken() throws IOException {
        token = "";
        block0: while (true) {
            ch = this.catfile.read();
            while (ch <= 32) {
                ch = this.catfile.read();
                if (ch >= 0) continue;
                return null;
            }
            nextch = this.catfile.read();
            if (nextch < 0) {
                return null;
            }
            if (ch != 45 || nextch != 45) break;
            ch = 32;
            nextch = this.nextChar();
            while (true) {
                if (ch == 45 && nextch == 45) continue block0;
                ch = nextch;
                nextch = this.nextChar();
            }
            break;
        }
        this.stack[++this.top] = nextch;
        this.stack[++this.top] = ch;
        ch = this.nextChar();
        if (ch != 34 && ch != 39) ** GOTO lbl39
        quote = ch;
        while ((ch = this.nextChar()) != quote) {
            chararr = new char[]{(char)ch};
            s = new String(chararr);
            token = token.concat(s);
        }
        return token;
lbl-1000:
        // 1 sources

        {
            nextch = this.nextChar();
            if (ch == 45 && nextch == 45) {
                this.stack[++this.top] = ch;
                this.stack[++this.top] = nextch;
                return token;
            }
            chararr = new char[]{(char)ch};
            s = new String(chararr);
            token = token.concat(s);
            ch = nextch;
lbl39:
            // 2 sources

            ** while (ch > 32)
        }
lbl40:
        // 1 sources

        return token;
    }

    private int nextChar() throws IOException {
        if (this.top < 0) {
            return this.catfile.read();
        }
        return this.stack[this.top--];
    }

    private void debug(int level, String message, String token) {
        if (this.debug >= level) {
            System.out.println(message + ": " + token);
        }
    }

    private void debug(int level, String message, String token, String spec) {
        if (this.debug >= level) {
            System.out.println(message + ": " + token + " " + spec);
        }
    }

    private void debug(int level, String message, String token, String spec1, String spec2) {
        if (this.debug >= level) {
            System.out.println(message + ": " + token + " " + spec1);
            System.out.println("\t" + spec2);
        }
    }
}

