/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.testcase;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import org.apache.avalon.excalibur.component.DefaultRoleManager;
import org.apache.avalon.excalibur.component.ExcaliburComponentManager;
import org.apache.avalon.excalibur.logger.DefaultLogKitManager;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.DefaultContext;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.format.Formatter;
import org.apache.log.format.PatternFormatter;
import org.apache.log.output.io.StreamTarget;

public class ExcaliburTestCase
extends TestCase {
    private static final String FORMAT = "%7.7{priority} %5.5{time}   [%8.8{category}] (%{context}): %{message}\\n%{throwable}";
    private static HashMap m_tests = new HashMap();
    private Logger m_logger;
    private LogKitLogger m_logEnabledLogger;
    private ExcaliburComponentManager m_manager;
    protected Priority m_logPriority = Priority.DEBUG;
    protected ComponentManager manager;

    protected Logger getLogger() {
        if (this.m_logger == null) {
            this.m_logger = this.setupLogger();
        }
        return this.m_logger;
    }

    protected LogKitLogger getLogEnabledLogger() {
        if (this.m_logEnabledLogger == null) {
            this.m_logEnabledLogger = new LogKitLogger(this.getLogger());
        }
        return this.m_logEnabledLogger;
    }

    protected void prepare() throws Exception {
        String resourceName = ((Object)((Object)this)).getClass().getName().replace('.', '/') + ".xtest";
        URL resource = ((Object)((Object)this)).getClass().getClassLoader().getResource(resourceName);
        if (resource != null) {
            this.getLogger().debug("Loading resource " + resourceName);
            this.prepare(resource.openStream());
        } else {
            this.getLogger().debug("Resource not found " + resourceName);
        }
    }

    protected final void prepare(InputStream testconf) throws Exception {
        this.getLogger().debug("ExcaliburTestCase.initialize");
        DefaultConfigurationBuilder builder = new DefaultConfigurationBuilder();
        Configuration conf = builder.build(testconf);
        String annotation = conf.getChild("annotation").getValue(null);
        if (annotation != null || !"".equals(annotation)) {
            this.m_logger.info(annotation);
        }
        Context context = this.setupContext(conf.getChild("context"));
        this.m_manager = this.setupComponentManager(conf.getChild("components"), conf.getChild("roles"), conf.getChild("logkit"), context);
        this.manager = this.m_manager;
    }

    private final void done() {
        if (this.m_manager != null) {
            this.m_manager.dispose();
        }
        this.m_manager = null;
    }

    /*
     * Loose catch block
     */
    public final void run(TestResult result) {
        ArrayList methodList;
        block15: {
            methodList = (ArrayList)m_tests.get(((Object)((Object)this)).getClass());
            if (methodList == null || methodList.isEmpty()) {
                return;
            }
            try {
                if (this instanceof Initializable) {
                    ((Initializable)this).initialize();
                }
                this.prepare();
                Iterator tests = ((AbstractList)methodList).iterator();
                while (tests.hasNext()) {
                    String methodName = (String)tests.next();
                    this.setName(methodName);
                    this.m_logger = null;
                    if (this.getLogger().isDebugEnabled()) {
                        this.getLogger().debug("Now running the following test: " + methodName);
                    }
                    super.run(result);
                }
                Object var4_6 = null;
                this.done();
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                this.done();
                if (this instanceof Disposable) {
                    try {
                        ((Disposable)this).dispose();
                    }
                    catch (Exception e2) {
                        result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                    }
                }
                throw throwable;
            }
            if (this instanceof Disposable) {
                try {
                    ((Disposable)this).dispose();
                }
                catch (Exception e2) {
                    result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                }
            }
            break block15;
            {
                catch (Exception e) {
                    result.addFailure((Test)this, new AssertionFailedError());
                    Object var4_7 = null;
                    this.done();
                    if (this instanceof Disposable) {
                        try {
                            ((Disposable)this).dispose();
                        }
                        catch (Exception e2) {
                            result.addFailure((Test)this, new AssertionFailedError("Disposal Error"));
                        }
                    }
                }
            }
        }
        methodList.clear();
        m_tests.put(((Object)((Object)this)).getClass(), methodList);
    }

    private final Logger setupLogger() {
        Logger logger = Hierarchy.getDefaultHierarchy().getLoggerFor(this.getName());
        logger.setPriority(this.m_logPriority);
        PatternFormatter formatter = new PatternFormatter(FORMAT);
        StreamTarget target = new StreamTarget((OutputStream)System.out, (Formatter)formatter);
        logger.setLogTargets(new LogTarget[]{target});
        return logger;
    }

    private final Context setupContext(Configuration conf) throws Exception {
        DefaultContext context = new DefaultContext();
        Configuration[] confs = conf.getChildren("entry");
        int i = 0;
        while (i < confs.length) {
            String key = confs[i].getAttribute("name");
            String value = confs[i].getAttribute("value", null);
            if (value == null) {
                String clazz = confs[i].getAttribute("class");
                Object obj = ((Object)((Object)this)).getClass().getClassLoader().loadClass(clazz).newInstance();
                context.put((Object)key, obj);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("ExcaliburTestCase: added an instance of class " + clazz + " to context entry " + key);
                }
            } else {
                context.put((Object)key, (Object)value);
                if (this.getLogger().isInfoEnabled()) {
                    this.getLogger().info("ExcaliburTestCase: added value \"" + value + "\" to context entry " + key);
                }
            }
            ++i;
        }
        this.addContext(context);
        return context;
    }

    protected void addContext(DefaultContext context) {
    }

    private final ExcaliburComponentManager setupComponentManager(Configuration confCM, Configuration confRM, Configuration confLM, Context context) throws Exception {
        DefaultRoleManager roleManager = new DefaultRoleManager();
        roleManager.setLogger(this.getLogger());
        roleManager.configure(confRM);
        DefaultLogKitManager logKitManager = new DefaultLogKitManager();
        logKitManager.enableLogging((org.apache.avalon.framework.logger.Logger)this.getLogEnabledLogger());
        logKitManager.contextualize(context);
        logKitManager.configure(confLM);
        ExcaliburComponentManager manager = new ExcaliburComponentManager();
        manager.setLogger(this.getLogger());
        manager.setRoleManager(roleManager);
        manager.contextualize(context);
        manager.setLogKitManager(logKitManager);
        manager.configure(confCM);
        manager.initialize();
        return manager;
    }

    public ExcaliburTestCase(String name) {
        super(name);
        ArrayList<String> methodList = (ArrayList<String>)m_tests.get(((Object)((Object)this)).getClass());
        Method[] methods = ((Object)((Object)this)).getClass().getDeclaredMethods();
        if (methodList == null) {
            methodList = new ArrayList<String>(methods.length);
            int i = 0;
            while (i < methods.length) {
                String methodName = methods[i].getName();
                if (methodName.startsWith("test") && Modifier.isPublic(methods[i].getModifiers()) && methods[i].getReturnType().equals(Void.TYPE) && methods[i].getParameterTypes().length == 0) {
                    methodList.add(methodName);
                }
                ++i;
            }
            m_tests.put(((Object)((Object)this)).getClass(), methodList);
        }
    }
}

