/*
 * Decompiled with CFR 0.152.
 */
package xjavadoc;

import java.beans.Introspector;
import xjavadoc.AbstractClass;
import xjavadoc.AbstractExecutableMember;
import xjavadoc.Util;
import xjavadoc.XClass;
import xjavadoc.XMethod;
import xjavadoc.XProgramElement;

final class MethodImpl
extends AbstractExecutableMember
implements XMethod {
    public static int instanceCount = 0;
    private String _returnType;
    private int _returnDimension;
    private String _dimensionAsString;
    private String methodNameWithSignatureAndModifiers = null;
    private String methodNameWithSignatureWithoutModifiers = null;

    public MethodImpl(AbstractClass containingClass) {
        super(containingClass);
        if (containingClass.isInterface()) {
            this.addModifier(1);
        }
        ++instanceCount;
    }

    public final boolean isConstructor() {
        return false;
    }

    public final XClass getReturnType() {
        return this.getType();
    }

    public final XClass getType() {
        return this.getContainingAbstractClass().qualify(this._returnType);
    }

    public final int getReturnDimension() {
        return this.getDimension();
    }

    public final int getDimension() {
        return this._returnDimension;
    }

    public String getReturnDimensionAsString() {
        return this.getDimensionAsString();
    }

    public String getDimensionAsString() {
        if (this._dimensionAsString == null) {
            this._dimensionAsString = Util.appendDimensionAsString(this.getDimension(), new StringBuffer()).toString();
        }
        return this._dimensionAsString;
    }

    public XProgramElement getSuperElement() {
        return this.getSuperElement(true);
    }

    public boolean isReturnTypeDefinedInFullQualifiedFormat() {
        return this._returnType.equals(this.getReturnType().getQualifiedName());
    }

    public boolean isPropertyAccessor() {
        boolean signatureOk = false;
        boolean nameOk = false;
        if (this.getName().startsWith("is")) {
            boolean bl = signatureOk = this.getType().getQualifiedName().equals("boolean") || this.getType().getQualifiedName().equals("java.lang.Boolean");
            if (this.getName().length() > 2) {
                nameOk = Character.isUpperCase(this.getName().charAt(2));
            }
        }
        if (this.getName().startsWith("get")) {
            signatureOk = true;
            if (this.getName().length() > 3) {
                nameOk = Character.isUpperCase(this.getName().charAt(3));
            }
        }
        boolean noParams = this.getParameters().size() == 0;
        return signatureOk && nameOk && noParams;
    }

    public boolean isPropertyMutator() {
        boolean nameOk = false;
        if (this.getName().startsWith("set") && this.getName().length() > 3) {
            nameOk = Character.isUpperCase(this.getName().charAt(3));
        }
        boolean oneParam = this.getParameters().size() == 1;
        return nameOk && oneParam;
    }

    public String getPropertyName() {
        String result = null;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            result = Introspector.decapitalize(this.getName().substring(3));
        } else if (this.getName().startsWith("is")) {
            result = Introspector.decapitalize(this.getName().substring(2));
        }
        return result;
    }

    public final void setReturnType(String returnType) {
        this._returnType = returnType;
    }

    public final void setReturnDimension(int d) {
        this._returnDimension = d;
    }

    public boolean equals(Object o) {
        MethodImpl other = (MethodImpl)o;
        return this.getMethodNameWithSignatureWithoutModifiers().equals(other.getMethodNameWithSignatureWithoutModifiers());
    }

    public int hashCode() {
        return this.toString(false).hashCode();
    }

    public String toString() {
        return this.getMethodNameWithSignatureAndModifiers();
    }

    protected String buildStringId() {
        return this.getMethodNameWithSignatureWithoutModifiers();
    }

    private String getMethodNameWithSignatureAndModifiers() {
        if (this.methodNameWithSignatureAndModifiers == null) {
            this.methodNameWithSignatureAndModifiers = this.toString(true);
        }
        return this.methodNameWithSignatureAndModifiers;
    }

    private String getMethodNameWithSignatureWithoutModifiers() {
        if (this.methodNameWithSignatureWithoutModifiers == null) {
            this.methodNameWithSignatureWithoutModifiers = this.toString(false);
        }
        return this.methodNameWithSignatureWithoutModifiers;
    }

    private String toString(boolean modifiers) {
        StringBuffer sb = modifiers ? new StringBuffer(this.getModifiers()).append(' ') : new StringBuffer();
        sb.append(this.getReturnType().getQualifiedName());
        sb.append(this.getDimensionAsString());
        sb.append(' ');
        sb.append(this.getNameWithSignature(false));
        return sb.toString();
    }
}

