/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.xml;

import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.avalon.excalibur.pool.Recyclable;
import org.apache.avalon.excalibur.xml.Parser;
import org.apache.avalon.excalibur.xml.XMLConsumer;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.parameters.Parameters;
import org.w3c.dom.Document;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;

public class JaxpParser
extends AbstractLoggable
implements Parser,
ErrorHandler,
Configurable,
Recyclable {
    protected SAXParserFactory factory;
    protected DocumentBuilderFactory docfactory;

    public void configure(Configuration config) throws ConfigurationException {
        Parameters params = Parameters.fromConfiguration((Configuration)config);
        boolean validate = params.getParameterAsBoolean("validate", false);
        this.factory = SAXParserFactory.newInstance();
        this.docfactory = DocumentBuilderFactory.newInstance();
        this.factory.setNamespaceAware(true);
        this.factory.setValidating(validate);
        this.docfactory.setNamespaceAware(true);
        this.docfactory.setValidating(validate);
    }

    public void parse(InputSource in, ContentHandler consumer) throws SAXException, IOException {
        SAXParser parser = null;
        try {
            parser = this.factory.newSAXParser();
        }
        catch (ParserConfigurationException e) {
            this.getLogger().error("Cannot produce a valid parser", (Throwable)e);
            throw new SAXException("Could not get valid parser" + e.getMessage(), e);
        }
        XMLReader reader = parser.getXMLReader();
        reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        try {
            if (consumer instanceof XMLConsumer || consumer instanceof LexicalHandler) {
                reader.setProperty("http://xml.org/sax/properties/lexical-handler", (LexicalHandler)((Object)consumer));
            }
        }
        catch (SAXException e) {
            this.getLogger().warn("SAX2 driver does not support property: 'http://xml.org/sax/properties/lexical-handler'");
        }
        reader.setErrorHandler(this);
        reader.setContentHandler(consumer);
        reader.parse(in);
    }

    public Document parseDocument(InputSource input) throws SAXException, IOException {
        DocumentBuilder builder = null;
        try {
            builder = this.docfactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            this.getLogger().error("Could not build DocumentBuilder", (Throwable)pce);
            return null;
        }
        return builder.parse(input);
    }

    public void error(SAXParseException e) throws SAXException {
        throw new SAXException("Error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void fatalError(SAXParseException e) throws SAXException {
        throw new SAXException("Fatal error parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void warning(SAXParseException e) throws SAXException {
        throw new SAXException("Warning parsing " + e.getSystemId() + " (line " + e.getLineNumber() + " col. " + e.getColumnNumber() + "): " + e.getMessage(), e);
    }

    public void recycle() {
    }
}

