/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import org.apache.log.ContextStack;
import org.apache.log.Hierarchy;
import org.apache.log.LogEvent;
import org.apache.log.LogTarget;
import org.apache.log.Priority;

public class Logger {
    public static final char CATEGORY_SEPARATOR = '.';
    private final Hierarchy m_hierarchy;
    private final Logger m_parent;
    private final String m_category;
    private Logger[] m_children;
    private LogTarget[] m_logTargets;
    private boolean m_logTargetsForceSet;
    private Priority m_priority;
    private boolean m_priorityForceSet;

    public final void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, message, throwable);
        }
    }

    public final void debug(String message) {
        if (this.isDebugEnabled()) {
            this.output(Priority.DEBUG, message, null);
        }
    }

    public final void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, message, throwable);
        }
    }

    public final void error(String message) {
        if (this.isErrorEnabled()) {
            this.output(Priority.ERROR, message, null);
        }
    }

    public final void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, message, throwable);
        }
    }

    public final void fatalError(String message) {
        if (this.isFatalErrorEnabled()) {
            this.output(Priority.FATAL_ERROR, message, null);
        }
    }

    public final Priority getPriority() {
        return this.m_priority;
    }

    public final String getCategory() {
        return this.m_category;
    }

    public final void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, message, throwable);
        }
    }

    public final void info(String message) {
        if (this.isInfoEnabled()) {
            this.output(Priority.INFO, message, null);
        }
    }

    public final void log(Priority priority, String message, Throwable throwable) {
        if (this.getPriority().isLowerOrEqual(priority)) {
            this.output(priority, message, throwable);
        }
    }

    public final void log(Priority priority, String message) {
        this.log(priority, message, null);
    }

    private final void output(Priority priority, String message, Throwable throwable) {
        LogEvent event = new LogEvent();
        event.setCategory(this.m_category);
        event.setContextStack(ContextStack.getCurrentContext());
        if (message != null) {
            event.setMessage(message);
        } else {
            event.setMessage("");
        }
        event.setThrowable(throwable);
        event.setPriority(priority);
        event.setTime(System.currentTimeMillis());
        this.output(event);
    }

    private final void output(LogEvent event) {
        LogTarget[] targets = this.m_logTargets;
        if (targets == null) {
            this.m_hierarchy.log("LogTarget is null for category '" + this.m_category + "'");
        } else {
            int i = 0;
            while (i < targets.length) {
                targets[i].processEvent(event);
                ++i;
            }
        }
    }

    public final void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, message, throwable);
        }
    }

    public final void warn(String message) {
        if (this.isWarnEnabled()) {
            this.output(Priority.WARN, message, null);
        }
    }

    public final boolean isDebugEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.DEBUG);
    }

    public final boolean isInfoEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.INFO);
    }

    public final boolean isWarnEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.WARN);
    }

    public final boolean isErrorEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.ERROR);
    }

    public final boolean isFatalErrorEnabled() {
        return this.getPriority().isLowerOrEqual(Priority.FATAL_ERROR);
    }

    public synchronized void setPriority(Priority priority) {
        this.m_priority = priority;
        this.m_priorityForceSet = true;
        this.resetChildPrioritys(false);
    }

    public synchronized void unsetPriority() {
        this.unsetPriority(false);
    }

    public synchronized void unsetPriority(boolean recursive) {
        this.m_priority = this.m_parent != null ? this.m_parent.getPriority() : Priority.DEBUG;
        this.m_priorityForceSet = false;
        this.resetChildPrioritys(recursive);
    }

    public synchronized Logger[] getChildren() {
        if (this.m_children == null) {
            return new Logger[0];
        }
        Logger[] children = new Logger[this.m_children.length];
        int i = 0;
        while (i < children.length) {
            children[i] = this.m_children[i];
            ++i;
        }
        return children;
    }

    private synchronized void resetChildPrioritys(boolean recursive) {
        if (this.m_children == null) {
            return;
        }
        Logger[] children = this.m_children;
        int i = 0;
        while (i < children.length) {
            children[i].resetPriority(recursive);
            ++i;
        }
    }

    private synchronized void resetPriority(boolean recursive) {
        if (recursive) {
            this.m_priorityForceSet = false;
        } else if (this.m_priorityForceSet) {
            return;
        }
        this.m_priority = this.m_parent.getPriority();
        this.resetChildPrioritys(recursive);
    }

    public synchronized LogTarget[] getLogTargets() {
        if (this.m_logTargets == null) {
            if (this.m_parent == null) {
                return new LogTarget[0];
            }
            return this.m_parent.getLogTargets();
        }
        LogTarget[] logTargets = new LogTarget[this.m_logTargets.length];
        int i = 0;
        while (i < logTargets.length) {
            logTargets[i] = this.m_logTargets[i];
            ++i;
        }
        return logTargets;
    }

    private synchronized void resetChildLogTargets(boolean recursive) {
        if (this.m_children == null) {
            return;
        }
        int i = 0;
        while (i < this.m_children.length) {
            this.m_children[i].resetLogTargets(recursive);
            ++i;
        }
    }

    private synchronized void resetLogTargets(boolean recursive) {
        if (recursive) {
            this.m_logTargetsForceSet = false;
        } else if (this.m_logTargetsForceSet) {
            return;
        }
        this.m_logTargets = this.m_parent.getLogTargets();
        this.resetChildLogTargets(recursive);
    }

    public synchronized void setLogTargets(LogTarget[] logTargets) {
        this.m_logTargets = logTargets;
        this.m_logTargetsForceSet = true;
        this.resetChildLogTargets(false);
    }

    public synchronized void unsetLogTargets() {
        this.unsetLogTargets(false);
    }

    public synchronized void unsetLogTargets(boolean recursive) {
        this.m_logTargets = this.m_parent != null ? this.m_parent.getLogTargets() : null;
        this.m_logTargetsForceSet = false;
        this.resetChildLogTargets(recursive);
    }

    public synchronized Logger getChildLogger(String subCategory) throws IllegalArgumentException {
        int end = subCategory.indexOf(46);
        String nextCategory = null;
        String remainder = null;
        if (-1 == end) {
            nextCategory = subCategory;
        } else {
            if (end == 0) {
                throw new IllegalArgumentException("Logger categories MUST not have empty elements");
            }
            nextCategory = subCategory.substring(0, end);
            remainder = subCategory.substring(end + 1);
        }
        String category = null;
        category = this.m_category.equals("") ? nextCategory : this.m_category + "." + nextCategory;
        if (this.m_children != null) {
            int i = 0;
            while (i < this.m_children.length) {
                if (this.m_children[i].getCategory().equals(category)) {
                    if (remainder == null) {
                        return this.m_children[i];
                    }
                    return this.m_children[i].getChildLogger(remainder);
                }
                ++i;
            }
        }
        Logger child = new Logger(this.m_hierarchy, category, null, this);
        if (this.m_children == null) {
            this.m_children = new Logger[]{child};
        } else {
            Logger[] children = new Logger[this.m_children.length + 1];
            System.arraycopy(this.m_children, 0, children, 0, this.m_children.length);
            children[this.m_children.length] = child;
            this.m_children = children;
        }
        if (remainder == null) {
            return child;
        }
        return child.getChildLogger(remainder);
    }

    protected Logger(Hierarchy hierarchy, String category, LogTarget[] logTargets, Logger parent) {
        this.m_hierarchy = hierarchy;
        this.m_category = category;
        this.m_logTargets = logTargets;
        this.m_parent = parent;
        if (this.m_logTargets == null) {
            this.unsetLogTargets();
        }
        this.unsetPriority();
    }
}

