/*
 * Decompiled with CFR 0.152.
 */
package xdoclet.util;

import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Category;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import xdoclet.XDocletException;
import xdoclet.util.FileManager;
import xdoclet.util.Log;
import xdoclet.util.Translator;

public class XmlValidator
extends DefaultHandler {
    private final HashMap _dtds = new HashMap();
    static /* synthetic */ Class class$xdoclet$util$XmlValidator;

    public void registerDTD(String publicId, String dtdFileName) {
        Category cat = Log.getCategory(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "registerDTD");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("DTD '" + dtdFileName + "' registered for public Id '" + publicId + "'."));
        }
        this._dtds.put(publicId, dtdFileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) {
        String dtdFileName;
        Category cat = Log.getCategory(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "resolveEntity");
        if (cat.isDebugEnabled()) {
            cat.debug((Object)("publicId=" + publicId));
            cat.debug((Object)("systemId=" + systemId));
        }
        if ((dtdFileName = (String)this._dtds.get(publicId)) != null) {
            String dtd = null;
            dtd = FileManager.getURLContent(this.getClass().getResource(dtdFileName));
            if (dtd == null) {
                try {
                    System.out.println(Translator.getString("couldnt_find_dtd", new String[]{dtdFileName}));
                }
                catch (XDocletException e) {
                    System.out.println(e.getMessage());
                }
            }
            if (cat.isDebugEnabled()) {
                cat.debug((Object)("dtdFileName != null, dtdFileName=" + dtdFileName));
                cat.debug((Object)("dtd.length()=" + dtd.length()));
            }
            return new InputSource(new StringReader(dtd));
        }
        if (cat.isDebugEnabled()) {
            cat.debug((Object)"dtdFileName == null");
        }
        try {
            System.out.println(Translator.getString("couldnt_load_local_dtd", new String[]{publicId}));
        }
        catch (XDocletException e) {
            System.out.println(e.getMessage());
        }
        return null;
    }

    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void warning(SAXParseException e) throws SAXParseException {
        throw e;
    }

    public void validate(File xmlFile) throws XDocletException {
        Category cat = Log.getCategory(class$xdoclet$util$XmlValidator == null ? (class$xdoclet$util$XmlValidator = XmlValidator.class$("xdoclet.util.XmlValidator")) : class$xdoclet$util$XmlValidator, "validate");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setValidating(true);
        try {
            SAXParser parser = factory.newSAXParser();
            cat.debug((Object)("Parsing " + xmlFile.getAbsolutePath()));
            parser.parse(xmlFile, (DefaultHandler)this);
            cat.debug((Object)"Parsing OK");
        }
        catch (SAXParseException e) {
            String message = Translator.getString("generated_xml_invalid", new String[]{e.getSystemId(), Integer.toString(e.getLineNumber()), e.getMessage()});
            throw new XDocletException(e, message);
        }
        catch (SAXException e) {
            throw new XDocletException(e, Translator.getString("couldnt_init_xml_parser"));
        }
        catch (IOException e) {
            throw new XDocletException(e, Translator.getString("couldnt_load_xml_file"));
        }
        catch (ParserConfigurationException e) {
            throw new XDocletException(e, Translator.getString("couldnt_conf_xml_parser"));
        }
        catch (NullPointerException e) {
            throw new XDocletException(e, Translator.getString("couldnt_load_dtd"));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

