/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class SoftRefHashMap
implements Map {
    private Map hashMap = new HashMap();

    public void purge() {
        Map map = this.getMap();
        Set set = map.keySet();
        if (set == null) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Reference reference = (Reference)map.get(k);
            if (reference.get() != null) continue;
            map.remove(k);
        }
    }

    public Object get(Object object) {
        Reference reference = (Reference)this.getMap().get(object);
        if (reference == null) {
            return null;
        }
        return reference.get();
    }

    public Object put(Object object, Object object2) {
        Reference reference = this.getMap().put(object, this.createReference(object2));
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public Collection values() {
        Set set = (Set)this.getMap().values();
        TreeSet treeSet = new TreeSet();
        if (set == null) {
            return treeSet;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Reference reference = (Reference)iterator.next();
            if (reference == null) continue;
            treeSet.add(reference.get());
        }
        return treeSet;
    }

    public boolean containsKey(Object object) {
        return this.getMap().containsKey(object);
    }

    public boolean containsValue(Object object) {
        Collection collection = this.getMap().values();
        if (collection == null) {
            return false;
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            Object t;
            Reference reference = (Reference)iterator.next();
            if (reference == null || (t = reference.get()) != object) continue;
            return true;
        }
        return false;
    }

    public void putAll(Map map) {
        if (map == null || map.size() == 0) {
            return;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            this.put(k, map.get(k));
        }
    }

    public Set entrySet() {
        HashSet<Entry> hashSet = new HashSet<Entry>();
        if (this.size() == 0) {
            return hashSet;
        }
        Iterator iterator = this.keySet().iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            Object object = this.get(e);
            Entry entry = new Entry(e, object);
            hashSet.add(entry);
        }
        return hashSet;
    }

    public Object remove(Object object) {
        Reference reference = (Reference)this.getMap().remove(object);
        if (reference != null) {
            return reference.get();
        }
        return null;
    }

    public void clear() {
        this.getMap().clear();
    }

    public int hashCode() {
        return this.getMap().hashCode();
    }

    public Set keySet() {
        return this.getMap().keySet();
    }

    public boolean isEmpty() {
        return this.getMap().isEmpty();
    }

    public boolean equals(Object object) {
        return this.getMap().equals(object);
    }

    public int size() {
        return this.getMap().size();
    }

    protected Reference createReference(Object object) {
        return new SoftReference<Object>(object);
    }

    protected Map getMap() {
        return this.hashMap;
    }

    class Entry
    implements Map.Entry {
        private Object key;
        private Object value;

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.value;
        }

        public Object setValue(Object object) {
            this.value = object;
            SoftRefHashMap.this.put(this.key, object);
            return object;
        }

        public int hashCode() {
            return (this.getKey() == null ? 0 : this.getKey().hashCode()) ^ (this.getValue() == null ? 0 : this.getValue().hashCode());
        }

        public Entry(Object object, Object object2) {
            this.key = object;
            this.value = object2;
        }
    }
}

