/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.framework.configuration;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.DefaultConfiguration;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.NamespaceSupport;

public class SAXConfigurationHandler
extends DefaultHandler
implements ErrorHandler {
    private final ArrayList m_elements = new ArrayList();
    private final ArrayList m_prefixes = new ArrayList();
    private Configuration m_configuration;
    private Locator m_locator;
    private NamespaceSupport m_namespaceSupport = new NamespaceSupport();

    public Configuration getConfiguration() {
        return this.m_configuration;
    }

    public void clear() {
        this.m_elements.clear();
        Iterator i = ((AbstractList)this.m_prefixes).iterator();
        while (i.hasNext()) {
            ((ArrayList)i.next()).clear();
        }
        this.m_prefixes.clear();
        this.m_locator = null;
    }

    public void setDocumentLocator(Locator locator) {
        this.m_locator = locator;
    }

    public void startDocument() throws SAXException {
        this.m_namespaceSupport.reset();
        super.startDocument();
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        this.m_namespaceSupport.reset();
    }

    public void characters(char[] ch, int start, int end) throws SAXException {
        String value = new String(ch, start, end).trim();
        if (value.equals("")) {
            return;
        }
        DefaultConfiguration configuration = (DefaultConfiguration)this.m_elements.get(this.m_elements.size() - 1);
        if (configuration.getChildCount() != 0) {
            throw new SAXException("Not allowed to define mixed content in the element " + configuration.getName() + " at " + configuration.getLocation());
        }
        value = configuration.getValue("") + value;
        configuration.setValue(value);
    }

    public void endElement(String namespaceURI, String localName, String rawName) throws SAXException {
        int location = this.m_elements.size() - 1;
        Object object = this.m_elements.remove(location);
        ArrayList prefixes = (ArrayList)this.m_prefixes.remove(location);
        Iterator i = ((AbstractList)prefixes).iterator();
        while (i.hasNext()) {
            this.endPrefixMapping((String)i.next());
        }
        prefixes.clear();
        if (location == 0) {
            this.m_configuration = (Configuration)object;
        }
        this.m_namespaceSupport.popContext();
    }

    protected DefaultConfiguration createConfiguration(String localName, String namespaceURI, String location) {
        String prefix = this.m_namespaceSupport.getPrefix(namespaceURI);
        return new DefaultConfiguration(localName, location, namespaceURI, prefix);
    }

    public void startElement(String namespaceURI, String localName, String rawName, Attributes attributes) throws SAXException {
        this.m_namespaceSupport.pushContext();
        ArrayList<String> prefixes = new ArrayList<String>();
        AttributesImpl componentAttr = new AttributesImpl();
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.getQName(i).startsWith("xmlns")) {
                prefixes.add(attributes.getLocalName(i));
                this.startPrefixMapping(attributes.getLocalName(i), attributes.getValue(i));
            } else {
                componentAttr.addAttribute(attributes.getURI(i), attributes.getLocalName(i), attributes.getQName(i), attributes.getType(i), attributes.getValue(i));
            }
            ++i;
        }
        DefaultConfiguration configuration = this.createConfiguration(localName, namespaceURI, this.getLocationString());
        int size = this.m_elements.size() - 1;
        if (size > -1) {
            DefaultConfiguration parent = (DefaultConfiguration)this.m_elements.get(size);
            if (parent.getValue(null) != null) {
                throw new SAXException("Not allowed to define mixed content in the element " + parent.getName() + " at " + parent.getLocation());
            }
            parent.addChild(configuration);
        }
        this.m_elements.add(configuration);
        this.m_prefixes.add(prefixes);
        int attributesSize = componentAttr.getLength();
        int i2 = 0;
        while (i2 < attributesSize) {
            String name = componentAttr.getQName(i2);
            String value = componentAttr.getValue(i2);
            configuration.setAttribute(name, value);
            ++i2;
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void warning(SAXParseException exception) throws SAXException {
        throw exception;
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        throw exception;
    }

    protected String getLocationString() {
        if (this.m_locator == null) {
            return "Unknown";
        }
        return this.m_locator.getSystemId() + ":" + this.m_locator.getLineNumber() + ":" + this.m_locator.getColumnNumber();
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.m_namespaceSupport.declarePrefix(prefix, uri);
        super.startPrefixMapping(prefix, uri);
    }
}

