/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Stack;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.FileScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.DataType;
import org.apache.tools.ant.types.PatternSet;
import org.apache.tools.ant.types.Reference;

public class FileSet
extends DataType {
    private PatternSet defaultPatterns = new PatternSet();
    private Vector additionalPatterns = new Vector();
    private File dir;
    private boolean useDefaultExcludes = true;

    public void setRefid(Reference r) throws BuildException {
        if (this.dir != null || this.defaultPatterns.countPatterns() > 0) {
            throw this.tooManyAttributes();
        }
        if (!this.additionalPatterns.isEmpty()) {
            throw this.noChildrenAllowed();
        }
        super.setRefid(r);
    }

    public void setDir(File dir) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!dir.exists()) {
            throw new BuildException(dir.getAbsolutePath() + " not found.");
        }
        if (!dir.isDirectory()) {
            throw new BuildException(dir.getAbsolutePath() + " is not a directory.");
        }
        this.dir = dir;
    }

    public File getDir(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDir(p);
        }
        return this.dir;
    }

    public PatternSet createPatternSet() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        PatternSet patterns = new PatternSet();
        this.additionalPatterns.addElement(patterns);
        return patterns;
    }

    public PatternSet.NameEntry createInclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createInclude();
    }

    public PatternSet.NameEntry createExclude() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return this.defaultPatterns.createExclude();
    }

    public void setIncludes(String includes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludes(includes);
    }

    public void setExcludes(String excludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludes(excludes);
    }

    public void setIncludesfile(File incl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setIncludesfile(incl);
    }

    public void setExcludesfile(File excl) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.defaultPatterns.setExcludesfile(excl);
    }

    public void setDefaultexcludes(boolean useDefaultExcludes) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.useDefaultExcludes = useDefaultExcludes;
    }

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        if (this.dir == null) {
            throw new BuildException("No directory specified for fileset.");
        }
        DirectoryScanner ds = new DirectoryScanner();
        this.setupDirectoryScanner(ds, p);
        ds.scan();
        return ds;
    }

    public void setupDirectoryScanner(FileScanner ds, Project p) {
        if (ds == null) {
            throw new IllegalArgumentException("ds cannot be null");
        }
        ds.setBasedir(this.dir);
        int i = 0;
        while (i < this.additionalPatterns.size()) {
            Object o = this.additionalPatterns.elementAt(i);
            this.defaultPatterns.append((PatternSet)o, p);
            ++i;
        }
        ds.setIncludes(this.defaultPatterns.getIncludePatterns(p));
        ds.setExcludes(this.defaultPatterns.getExcludePatterns(p));
        if (this.useDefaultExcludes) {
            ds.addDefaultExcludes();
        }
    }

    private FileSet getRef(Project p) {
        Object o;
        if (!this.checked) {
            Stack<FileSet> stk = new Stack<FileSet>();
            stk.push(this);
            this.dieOnCircularReference(stk, p);
        }
        if (!((o = this.ref.getReferencedObject(p)) instanceof FileSet)) {
            String msg = this.ref.getRefId() + " doesn't denote a fileset";
            throw new BuildException(msg);
        }
        return (FileSet)o;
    }
}

