/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.thread.impl;

import org.apache.avalon.excalibur.lang.ThreadContext;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.excalibur.pool.SoftResourceLimitingPool;
import org.apache.avalon.excalibur.thread.ThreadControl;
import org.apache.avalon.excalibur.thread.impl.DefaultThreadControl;
import org.apache.avalon.framework.activity.Executable;
import org.apache.avalon.framework.logger.LogKitLogger;
import org.apache.avalon.framework.logger.Loggable;
import org.apache.log.Logger;

class WorkerThread
extends Thread
implements Poolable,
Loggable {
    private org.apache.avalon.framework.logger.Logger m_logger;
    private SoftResourceLimitingPool m_pool;
    private Executable m_work;
    private DefaultThreadControl m_threadControl;
    private ThreadContext m_context;
    private boolean m_alive;

    public void setLogger(org.apache.avalon.framework.logger.Logger logger) {
        this.m_logger = logger;
    }

    public void setLogger(Logger logger) {
        this.setLogger((org.apache.avalon.framework.logger.Logger)new LogKitLogger(logger));
    }

    /*
     * WARNING - void declaration
     */
    public final synchronized void run() {
        this.debug("starting.");
        while (this.m_alive) {
            Object var2_1;
            this.waitUntilCondition(true);
            this.debug("running.");
            try {
                try {
                    if (this.m_context != null) {
                        ThreadContext.setThreadContext(this.m_context);
                    }
                    this.m_work.execute();
                    this.m_threadControl.finish(null);
                }
                catch (ThreadDeath threadDeath) {
                    void throwable;
                    this.debug("thread has died.");
                    this.m_threadControl.finish(threadDeath);
                    throw throwable;
                }
                catch (Throwable throwable) {
                    this.debug("error caught: " + throwable);
                    this.m_threadControl.finish(throwable);
                    var2_1 = null;
                    this.debug("done.");
                    this.m_work = null;
                    this.m_threadControl = null;
                }
                var2_1 = null;
                this.debug("done.");
                this.m_work = null;
                this.m_threadControl = null;
            }
            catch (Throwable throwable) {
                var2_1 = null;
                this.debug("done.");
                this.m_work = null;
                this.m_threadControl = null;
                throw throwable;
            }
            this.notify();
            if (this.m_pool != null) {
                this.m_pool.put((Poolable)this);
                continue;
            }
            this.m_alive = false;
        }
    }

    public void dispose() {
        this.debug("destroying.");
        this.m_alive = false;
        this.waitUntilCondition(false);
    }

    protected synchronized ThreadControl execute(Executable work) {
        this.m_work = work;
        this.m_threadControl = new DefaultThreadControl(this);
        this.debug("notifying this worker.");
        this.notify();
        return this.m_threadControl;
    }

    protected synchronized void executeAndWait(Executable work) {
        this.execute(work);
        this.waitUntilCondition(false);
    }

    private synchronized void waitUntilCondition(boolean hasWork) {
        while (hasWork == (this.m_work == null)) {
            try {
                this.debug("waiting.");
                this.wait();
                this.debug("notified.");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void debug(String message) {
    }

    protected WorkerThread(ThreadGroup group, String name, SoftResourceLimitingPool pool, ThreadContext context) {
        super(group, name);
        this.m_pool = pool;
        this.m_context = context;
        this.m_work = null;
        this.m_alive = true;
        this.setDaemon(false);
    }
}

