/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.i18n;

import org.apache.avalon.excalibur.i18n.Bundle;
import org.apache.avalon.excalibur.i18n.BundleInfo;
import org.apache.avalon.excalibur.i18n.BundleInfoMapper;
import org.apache.avalon.excalibur.i18n.BundleLoader;
import org.apache.avalon.excalibur.i18n.BundleSelector;
import org.apache.avalon.framework.component.ComponentManager;
import org.apache.avalon.framework.component.Composable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.logger.Loggable;

public class DefaultBundleLoader
extends AbstractLoggable
implements BundleLoader,
Composable {
    private String bundleClassName;
    private String bundleInfoMapperClassName;
    private BundleInfoMapper mapper;
    private boolean cacheAll;
    private String prefix;
    private String suffix;
    protected BundleSelector selector;
    protected ComponentManager manager = null;

    public void setBundleSelector(BundleSelector selector) {
        this.selector = selector;
    }

    public void compose(ComponentManager manager) {
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        this.bundleClassName = configuration.getAttribute("bundle");
        this.bundleInfoMapperClassName = configuration.getAttribute("mapper");
        this.cacheAll = configuration.getAttributeAsBoolean("preload-all-values", true);
        try {
            this.prefix = configuration.getChild("prefix", true).getValue();
        }
        catch (ConfigurationException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Prefix not provided in configuration, using none.");
            }
            this.prefix = "";
        }
        try {
            this.suffix = configuration.getChild("suffix", true).getValue();
        }
        catch (ConfigurationException e) {
            if (this.getLogger().isWarnEnabled()) {
                this.getLogger().warn("Suffix not provided in configuration, using none.");
            }
            this.suffix = "";
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("BundleLoader configured with bundle=" + this.bundleClassName + ", mapper=" + this.bundleInfoMapperClassName + ", prefix='" + this.prefix + "' and suffix='" + this.suffix + "'");
        }
        try {
            this.mapper = (BundleInfoMapper)Class.forName(this.bundleInfoMapperClassName).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("unable to load mapper", (Throwable)e);
        }
    }

    protected Bundle getBundleInstance() {
        try {
            return (Bundle)Class.forName(this.bundleClassName).newInstance();
        }
        catch (Exception e) {
            this.getLogger().error("could not create bundle instance", (Throwable)e);
            return null;
        }
    }

    protected BundleInfoMapper getMapper() {
        return this.mapper;
    }

    protected boolean cacheAllValues() {
        return this.cacheAll;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public Bundle loadBundle(BundleInfo bundleInfo) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Mapping bundle: " + bundleInfo);
        }
        String uri = this.getPrefix() + this.getMapper().map(bundleInfo) + this.getSuffix();
        Bundle bundle = null;
        Bundle parentBundle = null;
        BundleInfo parentBundleInfo = bundleInfo.getParent();
        try {
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Loading bundle from URI: " + uri);
            }
            if (parentBundleInfo != null) {
                parentBundle = (Bundle)this.selector.select((Object)parentBundleInfo);
            }
            if ((bundle = this.getBundleInstance()) instanceof Loggable) {
                ((Loggable)bundle).setLogger(this.getLogger());
            }
            bundle.setBundleInfo(bundleInfo);
            bundle.setParent(parentBundle);
            if (bundle instanceof Composable) {
                ((Composable)bundle).compose(this.manager);
            }
            bundle.setLoadOnInit(this.cacheAllValues());
            bundle.init(uri);
            bundle.setLastModified(System.currentTimeMillis());
        }
        catch (Exception e) {
            this.getLogger().error("Error while loading bundle: " + bundleInfo + ", uri " + uri, (Throwable)e);
            bundle = null;
        }
        return bundle;
    }

    public static class ConfigurationKeys {
        public static final String PREFIX = "prefix";
        public static final String SUFFIX = "suffix";
        public static final String BUNDLE = "bundle";
        public static final String MAPPER = "mapper";
        public static final String CACHE_ALL = "preload-all-values";
    }
}

