/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl;

import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.util.NamespaceSupport;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLSymbols;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLDocumentHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLComponent;
import org.apache.xerces.xni.parser.XMLComponentManager;
import org.apache.xerces.xni.parser.XMLConfigurationException;
import org.apache.xerces.xni.parser.XMLDocumentFilter;
import org.apache.xerces.xni.parser.XMLDocumentSource;

public class XMLNamespaceBinder
implements XMLComponent,
XMLDocumentFilter {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    protected static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String[] RECOGNIZED_FEATURES = new String[]{"http://xml.org/sax/features/namespaces"};
    private static final String[] RECOGNIZED_PROPERTIES = new String[]{"http://apache.org/xml/properties/internal/symbol-table", "http://apache.org/xml/properties/internal/error-reporter"};
    protected boolean fNamespaces;
    protected SymbolTable fSymbolTable;
    protected XMLErrorReporter fErrorReporter;
    protected XMLDocumentHandler fDocumentHandler;
    protected XMLDocumentSource fDocumentSource;
    protected NamespaceSupport fNamespaceSupport = new NamespaceSupport();
    protected boolean fOnlyPassPrefixMappingEvents;
    private NamespaceContext fNamespaceContext;
    private QName fAttributeQName = new QName();

    public XMLNamespaceBinder() {
        this(null);
    }

    public XMLNamespaceBinder(NamespaceContext namespaceContext) {
        this.fNamespaceContext = namespaceContext;
    }

    public NamespaceContext getNamespaceContext() {
        return this.fNamespaceSupport;
    }

    public void setOnlyPassPrefixMappingEvents(boolean bl) {
        this.fOnlyPassPrefixMappingEvents = bl;
    }

    public boolean getOnlyPassPrefixMappingEvents() {
        return this.fOnlyPassPrefixMappingEvents;
    }

    public void reset(XMLComponentManager xMLComponentManager) throws XNIException {
        try {
            this.fNamespaces = xMLComponentManager.getFeature(NAMESPACES);
        }
        catch (XMLConfigurationException xMLConfigurationException) {
            this.fNamespaces = true;
        }
        this.fSymbolTable = (SymbolTable)xMLComponentManager.getProperty(SYMBOL_TABLE);
        this.fErrorReporter = (XMLErrorReporter)xMLComponentManager.getProperty(ERROR_REPORTER);
        this.fNamespaceSupport.reset();
        NamespaceContext namespaceContext = this.fNamespaceContext;
        while (namespaceContext != null) {
            int n = namespaceContext.getDeclaredPrefixCount();
            int n2 = 0;
            while (n2 < n) {
                String string = namespaceContext.getDeclaredPrefixAt(n2);
                if (this.fNamespaceSupport.getURI(string) == null) {
                    String string2 = namespaceContext.getURI(string);
                    this.fNamespaceSupport.declarePrefix(string, string2);
                }
                ++n2;
            }
            namespaceContext = namespaceContext.getParentContext();
        }
    }

    public String[] getRecognizedFeatures() {
        return (String[])RECOGNIZED_FEATURES.clone();
    }

    public void setFeature(String string, boolean bl) throws XMLConfigurationException {
    }

    public String[] getRecognizedProperties() {
        return (String[])RECOGNIZED_PROPERTIES.clone();
    }

    public void setProperty(String string, Object object) throws XMLConfigurationException {
        if (string.startsWith("http://apache.org/xml/properties/")) {
            String string2 = string.substring("http://apache.org/xml/properties/".length());
            if (string2.equals("internal/symbol-table")) {
                this.fSymbolTable = (SymbolTable)object;
            } else if (string2.equals("internal/error-reporter")) {
                this.fErrorReporter = (XMLErrorReporter)object;
            }
            return;
        }
    }

    public void setDocumentHandler(XMLDocumentHandler xMLDocumentHandler) {
        this.fDocumentHandler = xMLDocumentHandler;
    }

    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    public void setDocumentSource(XMLDocumentSource xMLDocumentSource) {
        this.fDocumentSource = xMLDocumentSource;
    }

    public XMLDocumentSource getDocumentSource() {
        return this.fDocumentSource;
    }

    public void startGeneralEntity(String string, XMLResourceIdentifier xMLResourceIdentifier, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.startGeneralEntity(string, xMLResourceIdentifier, string2, augmentations);
        }
    }

    public void textDecl(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.textDecl(string, string2, augmentations);
        }
    }

    public void startDocument(XMLLocator xMLLocator, String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.startDocument(xMLLocator, string, augmentations);
        }
    }

    public void xmlDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.xmlDecl(string, string2, string3, augmentations);
        }
    }

    public void doctypeDecl(String string, String string2, String string3, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.doctypeDecl(string, string2, string3, augmentations);
        }
    }

    public void comment(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.comment(xMLString, augmentations);
        }
    }

    public void processingInstruction(String string, XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.processingInstruction(string, xMLString, augmentations);
        }
    }

    public void startPrefixMapping(String string, String string2, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startPrefixMapping(string, string2, augmentations);
        }
    }

    public void startElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleStartElement(qName, xMLAttributes, augmentations, false);
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
        }
    }

    public void emptyElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleStartElement(qName, xMLAttributes, augmentations, true);
            this.handleEndElement(qName, augmentations, true);
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
        }
    }

    public void characters(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.characters(xMLString, augmentations);
        }
    }

    public void ignorableWhitespace(XMLString xMLString, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.ignorableWhitespace(xMLString, augmentations);
        }
    }

    public void endElement(QName qName, Augmentations augmentations) throws XNIException {
        if (this.fNamespaces) {
            this.handleEndElement(qName, augmentations, false);
        } else if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endElement(qName, augmentations);
        }
    }

    public void endPrefixMapping(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null) {
            this.fDocumentHandler.endPrefixMapping(string, augmentations);
        }
    }

    public void startCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.startCDATA(augmentations);
        }
    }

    public void endCDATA(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.endCDATA(augmentations);
        }
    }

    public void endDocument(Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.endDocument(augmentations);
        }
    }

    public void endGeneralEntity(String string, Augmentations augmentations) throws XNIException {
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            this.fDocumentHandler.endGeneralEntity(string, augmentations);
        }
    }

    protected void handleStartElement(QName qName, XMLAttributes xMLAttributes, Augmentations augmentations, boolean bl) throws XNIException {
        String string;
        String string2;
        this.fNamespaceSupport.pushContext();
        if (qName.prefix == XMLSymbols.PREFIX_XMLNS) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementXMLNSPrefix", new Object[]{qName.rawname}, (short)2);
        }
        int n = xMLAttributes.getLength();
        int n2 = 0;
        while (n2 < n) {
            string2 = xMLAttributes.getLocalName(n2);
            String string3 = xMLAttributes.getPrefix(n2);
            if (string3 == XMLSymbols.PREFIX_XMLNS || string3 == XMLSymbols.EMPTY_STRING && string2 == XMLSymbols.PREFIX_XMLNS) {
                string = this.fSymbolTable.addSymbol(xMLAttributes.getValue(n2));
                if (string3 == XMLSymbols.PREFIX_XMLNS && string2 == XMLSymbols.PREFIX_XMLNS) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                if (string == NamespaceContext.XMLNS_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXMLNS", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                if (string2 == XMLSymbols.PREFIX_XML) {
                    if (string != NamespaceContext.XML_URI) {
                        this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                    }
                } else if (string == NamespaceContext.XML_URI) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "CantBindXML", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                }
                String string4 = string3 = string2 != XMLSymbols.PREFIX_XMLNS ? string2 : XMLSymbols.EMPTY_STRING;
                if (string == XMLSymbols.EMPTY_STRING && string2 != XMLSymbols.PREFIX_XMLNS) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "EmptyPrefixedAttName", new Object[]{xMLAttributes.getQName(n2)}, (short)2);
                } else {
                    this.fNamespaceSupport.declarePrefix(string3, string.length() != 0 ? string : null);
                    if (this.fDocumentHandler != null) {
                        this.fDocumentHandler.startPrefixMapping(string3, string, augmentations);
                    }
                }
            }
            ++n2;
        }
        string2 = qName.prefix != null ? qName.prefix : XMLSymbols.EMPTY_STRING;
        qName.uri = this.fNamespaceSupport.getURI(string2);
        if (qName.prefix == null && qName.uri != null) {
            qName.prefix = XMLSymbols.EMPTY_STRING;
        }
        if (qName.prefix != null && qName.uri == null) {
            this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "ElementPrefixUnbound", new Object[]{qName.prefix, qName.rawname}, (short)2);
        }
        int n3 = 0;
        while (n3 < n) {
            xMLAttributes.getName(n3, this.fAttributeQName);
            string = this.fAttributeQName.prefix != null ? this.fAttributeQName.prefix : XMLSymbols.EMPTY_STRING;
            String string5 = this.fAttributeQName.rawname;
            if (string5 == XMLSymbols.PREFIX_XMLNS) {
                this.fAttributeQName.uri = this.fNamespaceSupport.getURI(XMLSymbols.PREFIX_XMLNS);
                xMLAttributes.setName(n3, this.fAttributeQName);
            } else if (string != XMLSymbols.EMPTY_STRING) {
                this.fAttributeQName.uri = this.fNamespaceSupport.getURI(string);
                if (this.fAttributeQName.uri == null) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributePrefixUnbound", new Object[]{string, string5}, (short)2);
                }
                xMLAttributes.setName(n3, this.fAttributeQName);
            }
            ++n3;
        }
        int n4 = xMLAttributes.getLength();
        int n5 = 0;
        while (n5 < n4 - 1) {
            String string6 = xMLAttributes.getLocalName(n5);
            String string7 = xMLAttributes.getURI(n5);
            int n6 = n5 + 1;
            while (n6 < n4) {
                String string8 = xMLAttributes.getLocalName(n6);
                String string9 = xMLAttributes.getURI(n6);
                if (string6 == string8 && string7 == string9) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/1999/REC-xml-names-19990114", "AttributeNSNotUnique", new Object[]{qName.rawname, string6, string7}, (short)2);
                }
                ++n6;
            }
            ++n5;
        }
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents) {
            if (bl) {
                this.fDocumentHandler.emptyElement(qName, xMLAttributes, augmentations);
            } else {
                this.fDocumentHandler.startElement(qName, xMLAttributes, augmentations);
            }
        }
    }

    protected void handleEndElement(QName qName, Augmentations augmentations, boolean bl) throws XNIException {
        String string = qName.prefix != null ? qName.prefix : XMLSymbols.EMPTY_STRING;
        qName.uri = this.fNamespaceSupport.getURI(string);
        if (qName.uri != null) {
            qName.prefix = string;
        }
        if (this.fDocumentHandler != null && !this.fOnlyPassPrefixMappingEvents && !bl) {
            this.fDocumentHandler.endElement(qName, augmentations);
        }
        if (this.fDocumentHandler != null) {
            int n = this.fNamespaceSupport.getDeclaredPrefixCount();
            int n2 = n - 1;
            while (n2 >= 0) {
                String string2 = this.fNamespaceSupport.getDeclaredPrefixAt(n2);
                this.fDocumentHandler.endPrefixMapping(string2, augmentations);
                --n2;
            }
        }
        this.fNamespaceSupport.popContext();
    }
}

