/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log;

import java.util.Stack;

public class ContextStack {
    private static final ThreadLocal c_context = new ThreadLocal();
    private Stack m_stack = new Stack();

    public static final ContextStack getCurrentContext() {
        ContextStack contextStack = (ContextStack)c_context.get();
        if (contextStack == null) {
            contextStack = new ContextStack();
            contextStack.push(Thread.currentThread().getName());
            c_context.set(contextStack);
        }
        return contextStack;
    }

    public void clear() {
        this.m_stack.setSize(0);
    }

    public Object get(int n) {
        return this.m_stack.elementAt(n);
    }

    public Object pop() {
        return this.m_stack.pop();
    }

    public void push(Object object) {
        this.m_stack.push(object);
    }

    public void set(ContextStack contextStack) {
        this.clear();
        int n = contextStack.m_stack.size();
        int n2 = 0;
        while (n2 < n) {
            this.m_stack.push(contextStack.m_stack.elementAt(n2));
            ++n2;
        }
    }

    public int getSize() {
        return this.m_stack.size();
    }
}

