/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.util.datasource;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.avalon.AbstractLoggable;
import org.apache.avalon.Configuration;
import org.apache.avalon.ConfigurationException;
import org.apache.avalon.util.datasource.DataSourceComponent;

public class J2eeDataSource
extends AbstractLoggable
implements DataSourceComponent {
    public static final String JDBC_NAME = "java:comp/env/jdbc/";
    protected DataSource m_dataSource = null;

    public void configure(Configuration configuration) throws ConfigurationException {
        if (null == this.m_dataSource) {
            String string = configuration.getChild("dbname").getValue();
            try {
                InitialContext initialContext = new InitialContext();
                this.m_dataSource = (DataSource)initialContext.lookup(JDBC_NAME + string);
            }
            catch (NamingException namingException) {
                this.getLogger().error("Problem with JNDI lookup of datasource", namingException);
                throw new ConfigurationException("Could not use JNDI to find datasource", namingException);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        if (null == this.m_dataSource) {
            throw new SQLException("Can not access DataSource object");
        }
        return this.m_dataSource.getConnection();
    }
}

