/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.pool;

import java.util.ArrayList;
import java.util.List;
import org.apache.avalon.excalibur.concurrent.Lock;
import org.apache.avalon.excalibur.pool.ObjectFactory;
import org.apache.avalon.excalibur.pool.Pool;
import org.apache.avalon.excalibur.pool.Poolable;
import org.apache.avalon.framework.activity.Initializable;
import org.apache.avalon.framework.logger.AbstractLoggable;
import org.apache.avalon.framework.thread.ThreadSafe;

public abstract class AbstractPool
extends AbstractLoggable
implements Pool,
ThreadSafe {
    public static final int DEFAULT_POOL_SIZE = 8;
    protected final ObjectFactory m_factory;
    protected List m_active = new ArrayList();
    protected List m_ready = new ArrayList();
    protected Lock m_mutex = new Lock();
    protected boolean m_initialized = false;
    protected int m_min;

    protected void initialize() throws Exception {
        this.m_mutex.lock();
        int i = 0;
        while (i < 8) {
            this.m_ready.add(this.newPoolable());
            ++i;
        }
        this.m_initialized = true;
        this.m_mutex.unlock();
    }

    protected Poolable newPoolable() throws Exception {
        Object obj = this.m_factory.newInstance();
        return (Poolable)obj;
    }

    protected void removePoolable(Poolable poolable) {
        block2: {
            try {
                this.m_factory.decommission(poolable);
            }
            catch (Exception e) {
                if (!this.getLogger().isDebugEnabled()) break block2;
                this.getLogger().debug("Error decommissioning object", (Throwable)e);
            }
        }
    }

    protected final int size() {
        AbstractPool abstractPool = this;
        synchronized (abstractPool) {
            int n = this.m_active.size() + this.m_ready.size();
            Object var2_3 = null;
            return n;
        }
    }

    public abstract Poolable get() throws Exception;

    public abstract void put(Poolable var1);

    protected void internalGrow(int amount) throws Exception {
        int i = 0;
        while (i < amount) {
            block3: {
                try {
                    this.m_ready.add(this.newPoolable());
                }
                catch (Exception e) {
                    if (this.getLogger() == null || !this.getLogger().isDebugEnabled()) break block3;
                    this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": could not be instantiated.", (Throwable)e);
                }
            }
            ++i;
        }
    }

    protected void internalShrink(int amount) throws Exception {
        int i = 0;
        while (i < amount) {
            block4: {
                if (this.m_ready.size() > this.m_min) {
                    try {
                        this.removePoolable((Poolable)this.m_ready.remove(0));
                    }
                    catch (Exception e) {
                        if (this.getLogger() == null || !this.getLogger().isDebugEnabled()) break block4;
                        this.getLogger().debug(this.m_factory.getCreatedClass().getName() + ": improperly decommissioned.", (Throwable)e);
                    }
                }
            }
            ++i;
        }
    }

    public AbstractPool(ObjectFactory factory) throws Exception {
        this.m_factory = factory;
        if (!(this instanceof Initializable)) {
            this.initialize();
        }
    }
}

